/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl;

import java.sql.SQLException;
import javax.inject.Inject;
import org.dspace.content.DSpaceObject;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.xoai.services.api.HandleResolver;
import org.dspace.xoai.services.api.HandleResolverException;
import org.dspace.xoai.services.api.context.ContextService;
import org.dspace.xoai.services.api.context.ContextServiceException;

public class DSpaceHandleResolver
implements HandleResolver {
    @Inject
    private ContextService contextService;
    private final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public DSpaceObject resolve(String handle) throws HandleResolverException {
        try {
            return this.handleService.resolveToObject(this.contextService.getContext(), handle);
        }
        catch (SQLException | ContextServiceException e) {
            throw new HandleResolverException(e);
        }
    }

    public String getHandle(DSpaceObject object) throws HandleResolverException {
        try {
            return this.handleService.findHandle(this.contextService.getContext(), object);
        }
        catch (SQLException | ContextServiceException e) {
            throw new HandleResolverException(e);
        }
    }
}

