/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.cache;

import com.lyncode.xoai.dataprovider.core.Granularity;
import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.dataprovider.xml.xoai.Metadata;
import com.lyncode.xoai.dataprovider.xml.xoai.XOAIParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.dspace.content.Item;
import org.dspace.xoai.services.api.cache.XOAIItemCacheService;
import org.dspace.xoai.services.api.config.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class DSpaceXOAIItemCacheService
implements XOAIItemCacheService {
    private static final String ITEMDIR = File.separator + "items";
    @Autowired
    ConfigurationService configurationService;
    private String baseDir;

    private String getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = this.configurationService.getProperty("oai", "cache.dir") + ITEMDIR;
        }
        return this.baseDir;
    }

    private File getMetadataCache(Item item) {
        File dir = new File(this.getBaseDir());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String name = File.separator + item.getHandle().replace('/', '_');
        return new File(this.getBaseDir() + name);
    }

    public boolean hasCache(Item item) {
        return this.getMetadataCache(item).exists();
    }

    public Metadata get(Item item) throws IOException {
        Metadata metadata;
        System.out.println(FileUtils.readFileToString((File)this.getMetadataCache(item)));
        FileInputStream input = new FileInputStream(this.getMetadataCache(item));
        try {
            metadata = XOAIParser.parse((InputStream)input);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        input.close();
        return metadata;
    }

    public void put(Item item, Metadata metadata) throws IOException {
        FileOutputStream output = new FileOutputStream(this.getMetadataCache(item));
        try {
            XmlOutputContext context = XmlOutputContext.emptyContext((OutputStream)output, (Granularity)Granularity.Second);
            metadata.write(context);
            context.getWriter().flush();
            context.getWriter().close();
            output.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        catch (WritingXmlException e) {
            throw new IOException(e);
        }
    }

    public void delete(Item item) {
        this.getMetadataCache(item).delete();
    }

    public void deleteAll() throws IOException {
        FileUtils.deleteDirectory((File)new File(this.getBaseDir()));
    }
}

