/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.xoai;

import com.lyncode.xoai.dataprovider.data.Filter;
import com.lyncode.xoai.dataprovider.filter.Scope;
import com.lyncode.xoai.dataprovider.filter.conditions.AndCondition;
import com.lyncode.xoai.dataprovider.filter.conditions.Condition;
import com.lyncode.xoai.dataprovider.filter.conditions.CustomCondition;
import com.lyncode.xoai.dataprovider.filter.conditions.NotCondition;
import com.lyncode.xoai.dataprovider.filter.conditions.OrCondition;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.ParameterMap;
import org.apache.log4j.Logger;
import org.dspace.xoai.filter.AndFilter;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.NotFilter;
import org.dspace.xoai.filter.OrFilter;
import org.dspace.xoai.filter.results.SolrFilterResult;
import org.dspace.xoai.services.api.FieldResolver;
import org.dspace.xoai.services.api.context.ContextService;
import org.dspace.xoai.services.api.context.ContextServiceException;
import org.dspace.xoai.services.api.xoai.DSpaceFilterResolver;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDSpaceFilterResolver
implements DSpaceFilterResolver {
    private static final Logger LOGGER = Logger.getLogger(BaseDSpaceFilterResolver.class);
    @Autowired
    FieldResolver fieldResolver;
    @Autowired
    ContextService contextService;

    public DSpaceFilter getFilter(Condition condition) {
        if (condition instanceof AndCondition) {
            return (DSpaceFilter)this.getFilter((AndCondition)condition);
        }
        if (condition instanceof OrCondition) {
            return (DSpaceFilter)this.getFilter((OrCondition)condition);
        }
        if (condition instanceof NotCondition) {
            return (DSpaceFilter)this.getFilter((NotCondition)condition);
        }
        if (condition instanceof CustomCondition) {
            CustomCondition customCondition = (CustomCondition)condition;
            return (DSpaceFilter)customCondition.getFilter();
        }
        return (DSpaceFilter)condition.getFilter();
    }

    public String buildSolrQuery(Scope scope, Condition condition) {
        DSpaceFilter filter = this.getFilter(condition);
        SolrFilterResult result = filter.buildSolrQuery();
        if (result.hasResult()) {
            if (scope == Scope.MetadataFormat) {
                return "(item.deleted:true OR (" + result.getQuery() + "))";
            }
            return "(" + result.getQuery() + ")";
        }
        return "true";
    }

    public Filter getFilter(Class<? extends Filter> filterClass, ParameterMap configuration) {
        Filter result = null;
        try {
            result = filterClass.newInstance();
            if (result instanceof DSpaceFilter) {
                ((DSpaceFilter)result).setConfiguration(configuration);
                ((DSpaceFilter)result).setContext(this.contextService.getContext());
                ((DSpaceFilter)result).setFieldResolver(this.fieldResolver);
            }
        }
        catch (IllegalAccessException | InstantiationException | ContextServiceException e) {
            LOGGER.error((Object)("Filter " + filterClass.getName() + " could not be instantiated"), e);
        }
        return result;
    }

    public Filter getFilter(AndCondition andCondition) {
        DSpaceFilter leftFilter = this.getFilter(andCondition.getLeft());
        DSpaceFilter rightFilter = this.getFilter(andCondition.getRight());
        return new AndFilter(leftFilter, rightFilter);
    }

    public Filter getFilter(OrCondition orCondition) {
        DSpaceFilter leftFilter = this.getFilter(orCondition.getLeft());
        DSpaceFilter rightFilter = this.getFilter(orCondition.getRight());
        return new OrFilter(leftFilter, rightFilter);
    }

    public Filter getFilter(NotCondition notCondition) {
        DSpaceFilter filter = this.getFilter(notCondition.getCondition());
        return new NotFilter(filter);
    }
}

