/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.util;

import com.lyncode.xoai.dataprovider.xml.xoai.Element;
import com.lyncode.xoai.dataprovider.xml.xoai.Metadata;
import com.lyncode.xoai.util.Base64Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.app.util.factory.UtilServiceFactory;
import org.dspace.app.util.service.MetadataExposureService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.util.URLUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemUtils {
    private static final Logger log = LogManager.getLogger(ItemUtils.class);
    private static final MetadataExposureService metadataExposureService = UtilServiceFactory.getInstance().getMetadataExposureService();
    private static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private static final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();

    private static Element getElement(List<Element> list, String name) {
        for (Element e : list) {
            if (!name.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    private static Element create(String name) {
        Element e = new Element();
        e.setName(name);
        return e;
    }

    private static Element.Field createValue(String name, String value) {
        Element.Field e = new Element.Field();
        e.setValue(value);
        e.setName(name);
        return e;
    }

    public static Metadata retrieveMetadata(Context context, Item item) {
        Metadata metadata = new Metadata();
        List vals = itemService.getMetadata((DSpaceObject)item, "*", "*", "*", "*");
        for (MetadataValue val : vals) {
            Element language;
            MetadataField field = val.getMetadataField();
            try {
                if (metadataExposureService.isHidden(context, field.getMetadataSchema().getName(), field.getElement(), field.getQualifier())) {
                    continue;
                }
            }
            catch (SQLException se) {
                throw new RuntimeException(se);
            }
            Element valueElem = null;
            Element schema = ItemUtils.getElement((List)metadata.getElement(), (String)field.getMetadataSchema().getName());
            if (schema == null) {
                schema = ItemUtils.create((String)field.getMetadataSchema().getName());
                metadata.getElement().add(schema);
            }
            valueElem = schema;
            if (field.getElement() != null && !field.getElement().equals("")) {
                Element element = ItemUtils.getElement((List)schema.getElement(), (String)field.getElement());
                if (element == null) {
                    element = ItemUtils.create((String)field.getElement());
                    schema.getElement().add(element);
                }
                valueElem = element;
                if (field.getQualifier() != null && !field.getQualifier().equals("")) {
                    Element qualifier = ItemUtils.getElement((List)element.getElement(), (String)field.getQualifier());
                    if (qualifier == null) {
                        qualifier = ItemUtils.create((String)field.getQualifier());
                        element.getElement().add(qualifier);
                    }
                    valueElem = qualifier;
                }
            }
            if (val.getLanguage() != null && !val.getLanguage().equals("")) {
                language = ItemUtils.getElement((List)valueElem.getElement(), (String)val.getLanguage());
                if (language == null) {
                    language = ItemUtils.create((String)val.getLanguage());
                    valueElem.getElement().add(language);
                }
                valueElem = language;
            } else {
                language = ItemUtils.getElement((List)valueElem.getElement(), (String)"none");
                if (language == null) {
                    language = ItemUtils.create((String)"none");
                    valueElem.getElement().add(language);
                }
                valueElem = language;
            }
            valueElem.getField().add(ItemUtils.createValue((String)"value", (String)val.getValue()));
            if (val.getAuthority() == null) continue;
            valueElem.getField().add(ItemUtils.createValue((String)"authority", (String)val.getAuthority()));
            if (val.getConfidence() == 0) continue;
            valueElem.getField().add(ItemUtils.createValue((String)"confidence", (String)(val.getConfidence() + "")));
        }
        Element bundles = ItemUtils.create((String)"bundles");
        metadata.getElement().add(bundles);
        try {
            List bs = item.getBundles();
            for (Bundle b : bs) {
                Element bundle = ItemUtils.create((String)"bundle");
                bundles.getElement().add(bundle);
                bundle.getField().add(ItemUtils.createValue((String)"name", (String)b.getName()));
                Element bitstreams = ItemUtils.create((String)"bitstreams");
                bundle.getElement().add(bitstreams);
                List bits = b.getBitstreams();
                for (Bitstream bit : bits) {
                    List bi;
                    Element bitstream = ItemUtils.create((String)"bitstream");
                    bitstreams.getElement().add(bitstream);
                    String url = "";
                    String bsName = bit.getName();
                    String sid = String.valueOf(bit.getSequenceID());
                    String baseUrl = ConfigurationManager.getProperty((String)"oai", (String)"bitstream.baseUrl");
                    String handle = null;
                    List bn = bit.getBundles();
                    if (!bn.isEmpty() && !(bi = ((Bundle)bn.get(0)).getItems()).isEmpty()) {
                        handle = ((Item)bi.get(0)).getHandle();
                    }
                    if (bsName == null) {
                        List ext = bit.getFormat(context).getExtensions();
                        bsName = "bitstream_" + sid + (ext.isEmpty() ? "" : (String)ext.get(0));
                    }
                    url = handle != null && baseUrl != null ? baseUrl + "/bitstream/" + handle + "/" + sid + "/" + URLUtils.encode((String)bsName) : URLUtils.encode((String)bsName);
                    String cks = bit.getChecksum();
                    String cka = bit.getChecksumAlgorithm();
                    String oname = bit.getSource();
                    String name = bit.getName();
                    String description = bit.getDescription();
                    if (name != null) {
                        bitstream.getField().add(ItemUtils.createValue((String)"name", (String)name));
                    }
                    if (oname != null) {
                        bitstream.getField().add(ItemUtils.createValue((String)"originalName", (String)name));
                    }
                    if (description != null) {
                        bitstream.getField().add(ItemUtils.createValue((String)"description", (String)description));
                    }
                    bitstream.getField().add(ItemUtils.createValue((String)"format", (String)bit.getFormat(context).getMIMEType()));
                    bitstream.getField().add(ItemUtils.createValue((String)"size", (String)("" + bit.getSize())));
                    bitstream.getField().add(ItemUtils.createValue((String)"url", (String)url));
                    bitstream.getField().add(ItemUtils.createValue((String)"checksum", (String)cks));
                    bitstream.getField().add(ItemUtils.createValue((String)"checksumAlgorithm", (String)cka));
                    bitstream.getField().add(ItemUtils.createValue((String)"sid", (String)(bit.getSequenceID() + "")));
                }
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        Element other = ItemUtils.create((String)"others");
        other.getField().add(ItemUtils.createValue((String)"handle", (String)item.getHandle()));
        other.getField().add(ItemUtils.createValue((String)"identifier", (String)DSpaceItem.buildIdentifier((String)item.getHandle())));
        other.getField().add(ItemUtils.createValue((String)"lastModifyDate", (String)item.getLastModified().toString()));
        metadata.getElement().add(other);
        Element repository = ItemUtils.create((String)"repository");
        repository.getField().add(ItemUtils.createValue((String)"name", (String)ConfigurationManager.getProperty((String)"dspace.name")));
        repository.getField().add(ItemUtils.createValue((String)"mail", (String)ConfigurationManager.getProperty((String)"mail.admin")));
        metadata.getElement().add(repository);
        Element license = ItemUtils.create((String)"license");
        try {
            Bundle licBundle;
            List licBits;
            List licBundles = itemService.getBundles(item, "LICENSE");
            if (!licBundles.isEmpty() && !(licBits = (licBundle = (Bundle)licBundles.get(0)).getBitstreams()).isEmpty()) {
                Bitstream licBit = (Bitstream)licBits.get(0);
                try {
                    InputStream in = bitstreamService.retrieve(context, licBit);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    Utils.bufferedCopy((InputStream)in, (OutputStream)out);
                    license.getField().add(ItemUtils.createValue((String)"bin", (String)Base64Utils.encode((String)out.toString())));
                    metadata.getElement().add(license);
                }
                catch (IOException | SQLException | AuthorizeException e) {
                    log.warn((Object)e.getMessage(), e);
                }
            }
        }
        catch (SQLException e1) {
            log.warn((Object)e1.getMessage(), (Throwable)e1);
        }
        return metadata;
    }
}

