/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.adapters.rdf;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.codec.digest.DigestUtils;
import org.dspace.app.util.Util;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class AdapterSupport {
    protected ValueFactory valueFactory = ValueFactoryImpl.getInstance();
    private RDFHandler rdfHandler = null;
    private Context context = null;
    protected String baseUri = ConfigurationManager.getProperty((String)"dspace.url");
    private String metadataServiceUri = "/handle";

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setRDFHandler(RDFHandler handler) {
        this.rdfHandler = handler;
    }

    public RDFHandler getRDFHander() {
        return this.rdfHandler;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getMetadataServiceUri() {
        return this.metadataServiceUri;
    }

    public void setMetadataServiceUri(String metadataServiceUri) {
        this.metadataServiceUri = metadataServiceUri;
    }

    public String getMetadataURL(String identifier) {
        return this.getBaseUri() + this.getMetadataServiceUri() + "/" + identifier;
    }

    public Resource createResource(String handle) {
        return this.valueFactory.createURI(this.getMetadataURL(handle));
    }

    public Resource createResource(DSpaceObject object) {
        return this.valueFactory.createURI(this.getMetadataURL(object.getHandle()));
    }

    public Resource createResource(Community community) {
        return this.valueFactory.createURI(this.getMetadataURL(community.getHandle()));
    }

    public Resource createResource(Site site) {
        return this.valueFactory.createURI(this.getBaseUri());
    }

    public Resource createResource(Bitstream bitstream) {
        String url = this.getBaseUri() + "/retrieve/" + bitstream.getID();
        try {
            if (bitstream.getName() != null) {
                url = url + "/" + Util.encodeBitstreamName((String)bitstream.getName(), (String)"UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            if (bitstream.getName() != null) {
                url = url + "/" + bitstream.getName();
            }
            e.printStackTrace();
        }
        return this.valueFactory.createURI(url);
    }

    public String generateDefaultURI(String string) {
        return "sha:" + Utils.toHex((byte[])DigestUtils.sha((String)string));
    }

    public Resource createResource(Item item, Bitstream bitstream) {
        String url = this.getBaseUri() + "/bitstream/handle/" + item.getHandle() + "/" + bitstream.getSequenceID();
        try {
            url = url + "/" + Util.encodeBitstreamName((String)bitstream.getName(), (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            url = url + "/" + bitstream.getName();
            e.printStackTrace();
        }
        return this.valueFactory.createURI(url);
    }

    public Resource createResource(BitstreamFormat format) {
        return this.valueFactory.createURI(this.getBaseUri() + "/format/" + format.getID());
    }

    public void handleStatement(Resource subject, URI predicate, Date date) throws RDFHandlerException {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            XMLGregorianCalendar xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
            xmlCal.setFractionalSecond(null);
            xmlCal.setHour(Integer.MIN_VALUE);
            xmlCal.setMinute(Integer.MIN_VALUE);
            xmlCal.setSecond(Integer.MIN_VALUE);
            xmlCal.setMillisecond(Integer.MIN_VALUE);
            xmlCal.setTimezone(Integer.MIN_VALUE);
            this.handleStatement(subject, predicate, (Value)this.valueFactory.createLiteral(xmlCal));
        }
        catch (DatatypeConfigurationException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
    }

    public void handleStatement(Resource subject, URI predicate, String literal) throws RDFHandlerException {
        this.handleStatement(subject, predicate, (Value)this.valueFactory.createLiteral(literal));
    }

    public void handleStatement(Resource subject, URI predicate, Value object) throws RDFHandlerException {
        this.getRDFHander().handleStatement(this.valueFactory.createStatement(subject, predicate, object));
    }

    public void handleStatement(Statement statement) throws RDFHandlerException {
        this.getRDFHander().handleStatement(statement);
    }
}

