/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.adapters.rdf;

import java.util.HashMap;
import java.util.Map;
import org.dspace.adapters.rdf.Adapter;
import org.dspace.adapters.rdf.AdapterSupport;
import org.dspace.adapters.rdf.DSpaceCollectionAdapter;
import org.dspace.adapters.rdf.DSpaceCommunityAdapter;
import org.dspace.adapters.rdf.DSpaceItemAdapter;
import org.dspace.adapters.rdf.DSpaceObjectAdapter;
import org.dspace.adapters.rdf.DSpaceSiteAdapter;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;

public class DSpaceAdapterFactory
extends AdapterSupport {
    private boolean includeChildren = false;
    private Map<Class, DSpaceObjectAdapter> adapters = new HashMap<Class, DSpaceObjectAdapter>();

    public Adapter getAdapter(DSpaceObject object) {
        DSpaceObjectAdapter adapter = null;
        if (!this.adapters.containsKey(object.getClass())) {
            if (object instanceof Site) {
                adapter = new DSpaceSiteAdapter();
            } else if (object instanceof Community) {
                adapter = new DSpaceCommunityAdapter();
            } else if (object instanceof Collection) {
                adapter = new DSpaceCollectionAdapter();
            } else if (object instanceof Item) {
                adapter = new DSpaceItemAdapter();
            }
            adapter.setFactory(this);
            adapter.setContext(this.getContext());
            adapter.setBaseUri(this.getBaseUri());
            adapter.setMetadataServiceUri(this.getMetadataServiceUri());
            adapter.setRDFHandler(this.getRDFHander());
            this.adapters.put(object.getClass(), adapter);
        } else {
            adapter = this.adapters.get(object.getClass());
        }
        return adapter;
    }

    public boolean isIncludeChildren() {
        return this.includeChildren;
    }

    public void setIncludeChildren(boolean includeChildren) {
        this.includeChildren = includeChildren;
    }
}

