/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.adapters.rdf;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.dspace.adapters.rdf.DSpaceObjectAdapter;
import org.dspace.adapters.rdf.vocabularies.DC;
import org.dspace.adapters.rdf.vocabularies.DCTERMS;
import org.dspace.adapters.rdf.vocabularies.DS;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class DSpaceCollectionAdapter
extends DSpaceObjectAdapter {
    public void handleNamespaces() throws RDFHandlerException {
        RDFHandler rdfHandler = this.getRDFHander();
        rdfHandler.handleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        rdfHandler.handleNamespace("dc", "http://purl.org/dc/elements/1.1/");
        rdfHandler.handleNamespace("dcterms", "http://purl.org/dc/terms/");
        rdfHandler.handleNamespace("ds", "http://purl.org/dspace/model#");
    }

    public void handle(DSpaceObject collection) throws RDFHandlerException {
        this.handle((Collection)collection);
    }

    private void handleResourceMap(DSpaceObject object, Resource aggregation) throws RDFHandlerException, SQLException {
    }

    public void handle(Collection object) throws RDFHandlerException {
        try {
            Bitstream logo;
            String intro;
            Resource aggregation = this.createResource((DSpaceObject)object);
            this.handleStatement(aggregation, RDF.TYPE, (Value)DS.Collection);
            this.handleStatement(aggregation, DC.identifier_, (Value)this.valueFactory.createLiteral("hdl:" + object.getHandle(), DCTERMS.URI));
            this.handleStatement(aggregation, DC.title_, object.getName());
            this.handleStatement(aggregation, DC.creator_, ConfigurationManager.getProperty((String)"dspace.name"));
            String shortDesc = object.getMetadata("short_description");
            if (shortDesc != null && !shortDesc.trim().equals("")) {
                shortDesc = this.cleanHTML(shortDesc);
                this.handleStatement(aggregation, DCTERMS.abstract_, shortDesc);
            }
            if ((intro = object.getMetadata("introductory_text")) != null && !intro.trim().equals("")) {
                intro = this.cleanHTML(intro);
                this.handleStatement(aggregation, DCTERMS.abstract_, intro);
            }
            if ((logo = object.getLogo()) != null) {
                this.handleStatement(aggregation, DS.logo, (Value)this.createResource(logo));
            }
            this.handleStatement(aggregation, DCTERMS.modified_, new Date());
            for (Community community : object.getCommunities()) {
                this.handleStatement(aggregation, DS.isPartOfCommunity, (Value)this.createResource(community));
                this.getContext().removeCached((Object)community, community.getID());
            }
        }
        catch (SQLException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
    }

    public void handleChildren(DSpaceObject object) throws RDFHandlerException {
        Collection collection = (Collection)object;
        try {
            String source = ConfigurationManager.getProperty((String)"recent.submissions.sort-option");
            BrowserScope scope = new BrowserScope(this.getContext());
            scope.setCollection(collection);
            scope.setResultsPerPage(100);
            scope.setBrowseIndex(BrowseIndex.getItemBrowseIndex());
            scope.setOrder("DESC");
            for (SortOption so : SortOption.getSortOptions()) {
                if (!so.getName().equals(source)) continue;
                scope.setSortBy(so.getNumber());
                scope.setOrder("DESC");
            }
            BrowseEngine be = new BrowseEngine(this.getContext());
            List items = be.browse(scope).getResults();
            for (Item item : items) {
                this.getFactory().getAdapter((DSpaceObject)item).handle((DSpaceObject)item);
                item.decache();
            }
        }
        catch (SQLException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
        catch (BrowseException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
        catch (SortException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
    }
}

