/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.adapters.rdf;

import java.sql.SQLException;
import org.dspace.adapters.rdf.DSpaceObjectAdapter;
import org.dspace.adapters.rdf.vocabularies.DC;
import org.dspace.adapters.rdf.vocabularies.DCTERMS;
import org.dspace.adapters.rdf.vocabularies.DS;
import org.dspace.content.Bitstream;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class DSpaceCommunityAdapter
extends DSpaceObjectAdapter {
    public void handleNamespaces() throws RDFHandlerException {
        RDFHandler rdfHandler = this.getRDFHander();
        rdfHandler.handleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        rdfHandler.handleNamespace("dc", "http://purl.org/dc/elements/1.1/");
        rdfHandler.handleNamespace("dcterms", "http://purl.org/dc/terms/");
        rdfHandler.handleNamespace("ds", "http://purl.org/dspace/model#");
    }

    public void handle(DSpaceObject object) throws RDFHandlerException {
        this.handle((Community)object);
    }

    private void handleResourceMap(DSpaceObject object, Resource aggregation) throws RDFHandlerException, SQLException {
    }

    public void handle(Community object) throws RDFHandlerException {
        try {
            Community parent;
            String intro;
            Resource aggregation = this.createResource(object);
            this.handleStatement(aggregation, RDF.TYPE, (Value)DS.Community);
            this.handleStatement(aggregation, DC.identifier_, (Value)this.valueFactory.createLiteral("hdl:" + object.getHandle(), DCTERMS.URI));
            this.handleStatement(aggregation, DC.title_, object.getName());
            String shortDesc = object.getMetadata("short_description");
            if (shortDesc != null && !shortDesc.trim().equals("")) {
                shortDesc = this.cleanHTML(shortDesc);
                this.handleStatement(aggregation, DCTERMS.abstract_, shortDesc);
            }
            if ((intro = object.getMetadata("introductory_text")) != null && !intro.trim().equals("")) {
                intro = this.cleanHTML(intro);
                this.handleStatement(aggregation, DCTERMS.abstract_, intro);
            }
            if ((parent = object.getParentCommunity()) != null) {
                this.handleStatement(aggregation, DS.isPartOfCommunity, (Value)this.createResource(object.getParentCommunity()));
            } else {
                Site site = (Site)Site.find((Context)this.getContext(), (int)0);
                this.handleStatement(aggregation, DS.isPartOfSite, (Value)this.createResource(site));
            }
            for (Community community : object.getSubcommunities()) {
                this.handleStatement(aggregation, DS.hasCommunity, (Value)this.createResource(community));
            }
            for (Community community : object.getCollections()) {
                this.handleStatement(aggregation, DS.hasCollection, (Value)this.createResource((DSpaceObject)community));
            }
            Bitstream logo = object.getLogo();
            if (logo != null) {
                this.handleStatement(aggregation, DS.logo, (Value)this.createResource(logo));
            }
        }
        catch (SQLException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
    }

    public void handleChildren(DSpaceObject object) throws RDFHandlerException {
        Community community = (Community)object;
        try {
            for (Community community2 : community.getSubcommunities()) {
                this.getFactory().getAdapter((DSpaceObject)community2).handle((DSpaceObject)community2);
                this.getContext().removeCached((Object)community2, community2.getID());
            }
            for (Community community3 : community.getCollections()) {
                this.getFactory().getAdapter((DSpaceObject)community3).handle((DSpaceObject)community3);
                this.getContext().removeCached((Object)community3, community3.getID());
            }
        }
        catch (SQLException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
    }
}

