/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.adapters.rdf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;
import org.dspace.adapters.rdf.DSpaceObjectAdapter;
import org.dspace.adapters.rdf.vocabularies.DC;
import org.dspace.adapters.rdf.vocabularies.DCTERMS;
import org.dspace.adapters.rdf.vocabularies.DS;
import org.dspace.adapters.rdf.vocabularies.ORE;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchema;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class DSpaceItemAdapter
extends DSpaceObjectAdapter {
    public void handleNamespaces() throws RDFHandlerException {
        RDFHandler rdfHandler = this.getRDFHander();
        rdfHandler.handleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        rdfHandler.handleNamespace("dc", "http://purl.org/dc/elements/1.1/");
        rdfHandler.handleNamespace("dcterms", "http://purl.org/dc/terms/");
        rdfHandler.handleNamespace("ds", "http://purl.org/dspace/model#");
    }

    public void handle(DSpaceObject object) throws RDFHandlerException {
        this.handle((Item)object);
    }

    private void handleResourceMap(Item item, Resource aggregation) throws RDFHandlerException, SQLException {
        URI rem = this.valueFactory.createURI(aggregation.stringValue(), "#rem");
        this.handleStatement((Resource)rem, RDF.TYPE, (Value)ORE.ResourceMap);
        Object xmlCal = null;
        DCValue[] values = item.getMetadata("dc", "date", "accessioned", "*");
        if (values.length > 0) {
            Date created = new DCDate(values[0].value).toDate();
            this.handleStatement((Resource)rem, DCTERMS.created_, created);
        }
        Date lastModified = item.getLastModified();
        this.handleStatement((Resource)rem, DCTERMS.modified_, lastModified);
        this.handleStatement((Resource)rem, DC.creator_, ConfigurationManager.getProperty((String)"dspace.name"));
        for (Bundle licenses : item.getBundles("LICENSE")) {
            for (Bitstream bitstream : licenses.getBitstreams()) {
                this.handleStatement((Resource)rem, DCTERMS.license_, (Value)this.createResource(item, bitstream));
                this.getContext().removeCached((Object)bitstream, bitstream.getID());
            }
            this.getContext().removeCached((Object)licenses, licenses.getID());
        }
        for (Bundle licenses : item.getBundles("CC-LICENSE")) {
            for (Bitstream bitstream : licenses.getBitstreams()) {
                if ("license_url".equals(bitstream.getName())) {
                    try {
                        this.handleStatement((Resource)rem, DCTERMS.license_, (Value)this.valueFactory.createURI(DSpaceItemAdapter.getBitstream(bitstream)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.getContext().removeCached((Object)bitstream, bitstream.getID());
            }
            this.getContext().removeCached((Object)licenses, licenses.getID());
        }
        this.getContext().clearCache();
        this.handleStatement((Resource)rem, ORE.describes, (Value)aggregation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Item item) throws RDFHandlerException {
        Resource aggregation = this.createResource((DSpaceObject)item);
        try {
            Bundle[] origBundles = item.getBundles("ORIGINAL");
            this.handleStatement(aggregation, RDF.TYPE, (Value)DS.Item);
            for (DCValue dCValue : item.getMetadata("*", "*", "*", "*")) {
                if (dCValue.schema.equals("dc") && (dCValue.element.equals("format") || dCValue.element.equals("extent"))) continue;
                if (dCValue.schema.equals("dc") && !dCValue.element.equals("creator")) {
                    URI predicate = null;
                    boolean isUrl = false;
                    try {
                        URL url = new URL(dCValue.value);
                        isUrl = true;
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                    if (dCValue.qualifier != null) {
                        predicate = DCTERMS.DSPACE_DC_2_DCTERMS.get(dCValue.element + "." + dCValue.qualifier);
                        if (predicate == null) {
                            predicate = this.valueFactory.createURI("http://purl.org/dspace/model#", dCValue.qualifier);
                        }
                    } else if (predicate == null) {
                        predicate = DC.DSPACE_DC_2_DC.get(dCValue.element);
                    }
                    if (isUrl) {
                        this.handleStatement(aggregation, predicate, (Value)this.valueFactory.createLiteral(dCValue.value, DCTERMS.URI));
                        continue;
                    }
                    this.handleStatement(aggregation, predicate, dCValue.value);
                    continue;
                }
                if (dCValue.schema.equals("dc")) continue;
                String lookup = dCValue.element;
                if (dCValue.qualifier != null) {
                    lookup = lookup + "." + dCValue.qualifier;
                }
                try {
                    MetadataSchema schema = MetadataSchema.find((Context)this.getContext(), (String)dCValue.schema);
                    URI predicate = this.valueFactory.createURI(schema.getNamespace(), lookup);
                    this.handleStatement(aggregation, predicate, dCValue.value);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                for (DCValue dCValue : item.getCollections()) {
                    this.handleStatement(aggregation, DS.isPartOfCollection, (Value)this.createResource((DSpaceObject)dCValue));
                    this.getContext().removeCached((Object)dCValue, dCValue.getID());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            SailRepository myRepository = new SailRepository((Sail)new MemoryStore());
            myRepository.initialize();
            RepositoryConnection connection = myRepository.getConnection();
            for (Bundle bundle : origBundles) {
                for (Bitstream bitstream : bundle.getBitstreams()) {
                    Resource uri = this.createResource(item, bitstream);
                    this.handleStatement(aggregation, DS.hasBitstream, (Value)uri);
                    connection.add(this.valueFactory.createStatement(uri, DS.isPartOfItem, (Value)aggregation), new Resource[0]);
                    connection.add(this.valueFactory.createStatement(uri, RDF.TYPE, (Value)DS.Bitstream), new Resource[0]);
                    if (bitstream.getName() != null) {
                        connection.add(this.valueFactory.createStatement(uri, DC.title_, (Value)this.valueFactory.createLiteral(StringEscapeUtils.escapeXml((String)bitstream.getName()))), new Resource[0]);
                    }
                    if (bitstream.getDescription() != null) {
                        connection.add(this.valueFactory.createStatement(uri, DC.description_, (Value)this.valueFactory.createLiteral(StringEscapeUtils.escapeXml((String)bitstream.getDescription()))), new Resource[0]);
                    }
                    connection.add(this.valueFactory.createStatement(uri, DS.size, (Value)this.valueFactory.createLiteral(bitstream.getSize())), new Resource[0]);
                    connection.add(this.valueFactory.createStatement(uri, DS.messageDigest, (Value)this.valueFactory.createLiteral(StringEscapeUtils.escapeXml((String)bitstream.getChecksum()))), new Resource[0]);
                    connection.add(this.valueFactory.createStatement(uri, DS.messageDigestAlgorithm, (Value)this.valueFactory.createLiteral(StringEscapeUtils.escapeXml((String)bitstream.getChecksumAlgorithm()))), new Resource[0]);
                    BitstreamFormat format = bitstream.getFormat();
                    Resource fu = this.createResource(format);
                    connection.add(this.valueFactory.createStatement(uri, DCTERMS.format_, (Value)fu), new Resource[0]);
                    connection.add(this.valueFactory.createStatement(fu, RDF.TYPE, (Value)DS.BitstreamFormat), new Resource[0]);
                    connection.add(this.valueFactory.createStatement(fu, RDF.TYPE, (Value)DCTERMS.FileFormat), new Resource[0]);
                    connection.add(this.valueFactory.createStatement(fu, RDF.VALUE, (Value)this.valueFactory.createLiteral(StringEscapeUtils.escapeXml((String)format.getMIMEType()))), new Resource[0]);
                    connection.add(this.valueFactory.createStatement(fu, DC.description_, (Value)this.valueFactory.createLiteral(StringEscapeUtils.escapeXml((String)format.getDescription()))), new Resource[0]);
                    connection.add(this.valueFactory.createStatement(fu, DC.title_, (Value)this.valueFactory.createLiteral(StringEscapeUtils.escapeXml((String)format.getShortDescription()))), new Resource[0]);
                    String supportLevel = "Unknown";
                    if (format.getSupportLevel() == 1) {
                        supportLevel = "Known";
                    } else if (format.getSupportLevel() == 2) {
                        supportLevel = "Supported";
                    }
                    connection.add(this.valueFactory.createStatement(fu, DS.support, (Value)this.valueFactory.createLiteral(supportLevel)), new Resource[0]);
                    this.getContext().removeCached((Object)bitstream, bitstream.getID());
                }
                this.getContext().removeCached((Object)bundle, bundle.getID());
            }
            RepositoryResult statements = connection.getStatements(null, null, null, true, new Resource[0]);
            try {
                while (statements.hasNext() && !statements.isClosed()) {
                    Statement statement = (Statement)statements.next();
                    this.handleStatement(statement);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                statements.close();
                connection.close();
                myRepository.shutDown();
            }
        }
        catch (SQLException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getBitstream(Bitstream b) throws IOException, SQLException, AuthorizeException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(b.retrieve()));
        StringBuffer buffer = new StringBuffer();
        while ((line = in.readLine()) != null) {
            buffer.append(line);
        }
        return buffer.toString();
    }

    public void handleChildren(DSpaceObject object) throws RDFHandlerException {
    }
}

