/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.adapters.rdf;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.dspace.adapters.rdf.Adapter;
import org.dspace.adapters.rdf.AdapterSupport;
import org.dspace.adapters.rdf.DSpaceAdapterFactory;
import org.dspace.content.DSpaceObject;
import org.openrdf.rio.RDFHandlerException;
import org.w3c.tidy.Tidy;

public abstract class DSpaceObjectAdapter
extends AdapterSupport
implements Adapter {
    private DSpaceAdapterFactory factory;

    public abstract void handle(DSpaceObject var1) throws RDFHandlerException;

    public abstract void handleChildren(DSpaceObject var1) throws RDFHandlerException;

    public final void render(DSpaceObject object) throws RDFHandlerException {
        this.handleNamespaces();
        this.handle(object);
        if (this.getFactory().isIncludeChildren()) {
            this.handleChildren(object);
        }
    }

    public String cleanHTML(String original) {
        StringWriter writer = new StringWriter();
        Tidy tidy = new Tidy();
        tidy.setXHTML(true);
        tidy.setXmlOut(true);
        tidy.setPrintBodyOnly(true);
        tidy.setQuiet(true);
        tidy.parse((Reader)new StringReader(original), (Writer)writer);
        return writer.getBuffer().toString();
    }

    public void setFactory(DSpaceAdapterFactory factory) {
        this.factory = factory;
    }

    public DSpaceAdapterFactory getFactory() {
        return this.factory;
    }

    public void handleNamespaces() throws RDFHandlerException {
        this.getRDFHander().handleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    }
}

