/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.adapters.rdf;

import java.sql.SQLException;
import org.dspace.adapters.rdf.DSpaceObjectAdapter;
import org.dspace.adapters.rdf.vocabularies.DC;
import org.dspace.adapters.rdf.vocabularies.DS;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class DSpaceSiteAdapter
extends DSpaceObjectAdapter {
    public void handleNamespaces() throws RDFHandlerException {
        RDFHandler rdfHandler = this.getRDFHander();
        rdfHandler.handleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        rdfHandler.handleNamespace("dc", "http://purl.org/dc/elements/1.1/");
        rdfHandler.handleNamespace("dcterms", "http://purl.org/dc/terms/");
        rdfHandler.handleNamespace("ds", "http://purl.org/dspace/model#");
    }

    public void handle(DSpaceObject object) throws RDFHandlerException {
        this.handle((Site)object);
    }

    private void handleResourceMap(DSpaceObject object, Resource aggregation) throws RDFHandlerException, SQLException {
    }

    public void handle(Site object) throws RDFHandlerException {
        try {
            Resource aggregation = this.createResource(object);
            this.handleResourceMap((DSpaceObject)object, aggregation);
            this.handleStatement(aggregation, RDF.TYPE, (Value)DS.Site);
            this.handleStatement(aggregation, DC.title_, (Value)this.valueFactory.createLiteral(object.getName()));
            for (Community community : Community.findAllTop((Context)this.getContext())) {
                this.handleStatement(aggregation, DS.hasCommunity, (Value)this.createResource(community));
            }
        }
        catch (SQLException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
    }

    public void handleChildren(DSpaceObject object) throws RDFHandlerException {
        try {
            for (Community comm : Community.findAll((Context)this.getContext())) {
                this.getFactory().getAdapter((DSpaceObject)comm).handle((DSpaceObject)comm);
                this.getContext().removeCached((Object)comm, comm.getID());
            }
        }
        catch (SQLException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
    }
}

