/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.adapters.rdf;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.adapters.rdf.DSpaceAdapterFactory;
import org.dspace.adapters.rdf.RDFContentHandlerImpl;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.openrdf.rio.RDFHandlerException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class DSpaceXMLReader
implements XMLReader {
    private ContentHandler handler = null;
    private Context context = null;
    private DSpaceAdapterFactory factory = new DSpaceAdapterFactory();

    protected void init() {
        if (this.factory == null) {
            this.factory = new DSpaceAdapterFactory();
        }
        if (this.handler != null) {
            this.factory.setRDFHandler(new RDFContentHandlerImpl(this.handler));
        }
        if (this.context != null) {
            this.factory.setContext(this.context);
        }
    }

    public void parse(DSpaceObject object) throws RDFHandlerException {
        this.init();
        this.factory.getRDFHander().startRDF();
        this.factory.getAdapter(object).render(object);
        this.factory.getRDFHander().endRDF();
    }

    public void parse(String systemId) throws IOException, SAXException {
        try {
            this.init();
            DSpaceObject object = HandleManager.resolveToObject((Context)this.getContext(), (String)systemId);
            if (object != null) {
                this.factory.getRDFHander().startRDF();
                this.factory.getAdapter(object).render(object);
                this.factory.getRDFHander().endRDF();
            }
        }
        catch (SQLException e) {
            throw new SAXException(e.getMessage(), e);
        }
        catch (RDFHandlerException e) {
            throw new SAXException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void parse(InputSource source) throws IOException, SAXException {
        throw new SAXException("InputSource cannot be used in DSpaceXMLReader.");
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
        this.init();
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public void setErrorHandler(ErrorHandler handler) {
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
        this.init();
    }
}

