/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.adapters.rdf;

import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.adapters.rdf.DSpaceXMLReader;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;

public class Export {
    public static void main(String[] args) throws Throwable {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("i", "id", true, "handle of community, collection or item to export to RDF");
        options.addOption("f", "format", true, "Format of Export: [rdfxml|atom]");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, args);
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp(Export.class.getName(), options);
            System.exit(0);
        }
        DSpaceObject obj = null;
        Context ctx = new Context();
        if (line.hasOption("i")) {
            obj = HandleManager.resolveToObject((Context)ctx, (String)line.getOptionValue("i"));
        }
        if (obj == null) {
            obj = Site.find((Context)ctx, (int)0);
        }
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler th = null;
        th = line.hasOption("f") && line.getOptionValue("f").equals("atom") ? tf.newTransformerHandler(new StreamSource(Export.class.getResourceAsStream("atom.xsl"))) : tf.newTransformerHandler(new StreamSource(Export.class.getResourceAsStream("identity.xsl")));
        StreamResult streamResult = new StreamResult(System.out);
        th.setResult(streamResult);
        DSpaceXMLReader reader = new DSpaceXMLReader();
        reader.setContext(ctx);
        reader.setContentHandler(th);
        reader.parse(obj);
    }
}

