/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.adapters.rdf;

import info.aduna.xml.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public class RDFContentHandlerImpl
implements RDFHandler {
    protected ContentHandler handler;
    protected LexicalHandler lexer;
    public static final String CDATA = "CDATA";
    public static final String ID = "ID";
    public static final String IDREF = "IDREF";
    public static final String IDREFS = "IDREFS";
    public static final String NMTOKEN = "NMTOKEN";
    public static final String NMTOKENS = "NMTOKENS";
    public static final String ENTITY = "ENTITY";
    public static final String ENTITIES = "ENTITIES";
    public static final String NOTATION = "NOTATION";
    protected NamespaceSupport namespaces = new NamespaceSupport();
    protected boolean writingStarted;
    protected boolean headerWritten;
    protected Statement lastWrittenStatement;
    private static final Attributes EMPTY_ATTS = new AttributesImpl();
    private LiteralXMLReader literalReader;

    public RDFContentHandlerImpl(ContentHandler handler) {
        this.handler = handler;
        if (handler instanceof LexicalHandler) {
            this.lexer = (LexicalHandler)((Object)handler);
        }
        this.writingStarted = false;
        this.headerWritten = false;
        this.lastWrittenStatement = null;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.RDFXML;
    }

    public void startRDF() {
        if (this.writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.writingStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeader() throws SAXException {
        try {
            this.handleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.handler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF", this.qName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF"), EMPTY_ATTS);
        }
        finally {
            this.headerWritten = true;
        }
    }

    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            if (this.lastWrittenStatement != null) {
                this.handler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description", this.qName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description"));
                this.lastWrittenStatement = null;
            }
            this.handler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF", this.qName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF"));
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        finally {
            this.writingStarted = false;
            this.headerWritten = false;
        }
    }

    public void handleNamespace(String prefix, String namespace) {
        if (namespace == null) {
            throw new RuntimeException("namespace cannot be null");
        }
        try {
            if (prefix == null || !XMLUtil.isNCName((String)prefix)) {
                if (this.namespaces.getPrefix(namespace) == null) {
                    String nextPrefix = this.getNextPrefix();
                    this.namespaces.declarePrefix(nextPrefix, namespace);
                    this.handler.startPrefixMapping(nextPrefix, namespace);
                }
                return;
            }
            String existingNamespace = this.namespaces.getURI(prefix);
            if (existingNamespace == null) {
                if (XMLUtil.isNCName((String)prefix)) {
                    this.namespaces.declarePrefix(prefix, namespace);
                    this.handler.startPrefixMapping(prefix, namespace);
                } else {
                    String nextPrefix = this.getNextPrefix();
                    this.namespaces.declarePrefix(nextPrefix, namespace);
                    this.handler.startPrefixMapping(nextPrefix, namespace);
                }
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private String getNextPrefix() {
        String prefix = "ns";
        int number = 1;
        while (this.namespaces.getURI(prefix + number) != null) {
            ++number;
        }
        prefix = prefix + number;
        return prefix;
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        Resource subj = st.getSubject();
        URI pred = st.getPredicate();
        Value obj = st.getObject();
        String predString = pred.toString();
        int predSplitIdx = XMLUtil.findURISplitIndex((String)predString);
        if (predSplitIdx == -1) {
            throw new RDFHandlerException("Unable to create XML namespace-qualified name for predicate: " + predString);
        }
        try {
            AttributesImpl atts;
            if (!this.headerWritten) {
                this.writeHeader();
            }
            String predNamespace = predString.substring(0, predSplitIdx);
            String predLocalName = predString.substring(predSplitIdx);
            if (this.lastWrittenStatement == null || !st.getSubject().equals(this.lastWrittenStatement.getSubject())) {
                if (this.lastWrittenStatement != null) {
                    this.handler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description", this.qName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description"));
                    this.lastWrittenStatement = null;
                }
                atts = new AttributesImpl();
                if (subj instanceof BNode) {
                    BNode bNode = (BNode)subj;
                    atts.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.qName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID"), ID, bNode.getID());
                } else {
                    URI uri = (URI)subj;
                    atts.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", this.qName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about"), CDATA, uri.toString());
                }
                this.handler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description", this.qName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description"), atts);
                this.lastWrittenStatement = st;
            }
            atts = new AttributesImpl();
            if (obj instanceof Resource) {
                Resource objRes = (Resource)obj;
                this.namespaces.pushContext();
                if (objRes instanceof BNode) {
                    BNode bNode = (BNode)objRes;
                    String qName = this.qName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
                    atts.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", qName, ID, bNode.getID());
                } else {
                    URI uri = (URI)objRes;
                    String qName = this.qName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
                    atts.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", qName, CDATA, uri.toString());
                }
                String qName = this.qName(predNamespace, predLocalName);
                this.handler.startElement(predNamespace, predLocalName, qName, atts);
                this.handler.endElement(predNamespace, predLocalName, qName);
                this.namespaces.popContext();
            } else if (obj instanceof Literal) {
                Literal objLit = (Literal)obj;
                if (objLit.getLanguage() != null) {
                    atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", NMTOKEN, objLit.getLanguage());
                }
                boolean isXMLLiteral = false;
                URI datatype = objLit.getDatatype();
                if (datatype != null) {
                    isXMLLiteral = datatype.equals(RDF.XMLLITERAL);
                    if (isXMLLiteral) {
                        atts.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", this.qName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType"), CDATA, "Literal");
                    } else {
                        atts.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", this.qName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype"), CDATA, datatype.toString());
                    }
                }
                this.namespaces.pushContext();
                this.handleNamespace(null, predNamespace);
                this.handler.startElement(predNamespace, predLocalName, this.qName(predNamespace, predLocalName), atts);
                if (isXMLLiteral) {
                    this.parseLiteral(objLit.getLabel());
                } else {
                    char[] chars = objLit.getLabel().toCharArray();
                    this.handler.characters(chars, 0, chars.length);
                }
                this.handler.endElement(predNamespace, predLocalName, this.qName(predNamespace, predLocalName));
                this.namespaces.popContext();
            }
        }
        catch (SAXException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
    }

    private String qName(String namespace, String element) {
        String prefix = this.namespaces.getPrefix(namespace);
        return prefix == null || prefix.equals("") ? element : prefix + ":" + element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLiteral(String xmlString) throws SAXException {
        if (this.literalReader == null) {
            this.literalReader = new LiteralXMLReader();
            this.literalReader.setContentHandler(this.handler);
        }
        try {
            if (xmlString != null && xmlString.length() > 0) {
                this.literalReader.parse(new InputSource(new ByteArrayInputStream(xmlString.getBytes())));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleComment(String arg0) throws RDFHandlerException {
        if (this.lexer != null) {
            char[] comment = arg0.toCharArray();
            try {
                this.lexer.comment(comment, 0, comment.length);
            }
            catch (SAXException e) {
                throw new RDFHandlerException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected class LiteralXMLReader
    extends XMLFilterImpl {
        protected LiteralXMLReader() {
        }

        public void endDocument() throws SAXException {
        }

        public void startDocument() throws SAXException {
        }
    }
}

