/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.ItemIterator;
import org.dspace.content.Metadatum;
import org.dspace.content.service.ItemService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.rest.BitstreamResource;
import org.dspace.rest.Resource;
import org.dspace.rest.common.Bitstream;
import org.dspace.rest.common.Item;
import org.dspace.rest.common.MetadataEntry;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.usage.UsageEvent;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/items")
public class ItemsResource
extends Resource {
    private static final Logger log = Logger.getLogger(ItemsResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{item_id}")
    @Produces(value={"application/json", "application/xml"})
    public Item getItem(@PathParam(value="item_id") Integer itemId, @QueryParam(value="expand") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading item(id=" + itemId + ")."));
        org.dspace.core.Context context = null;
        Item item = null;
        try {
            context = ItemsResource.createContext((EPerson)ItemsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId.intValue(), 0);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.VIEW, user_ip, user_agent, xforwarderfor, headers, request, context);
            item = new Item(dspaceItem, expand, context);
            context.complete();
            log.trace((Object)("Item(id=" + itemId + ") was successfully read."));
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Item[] getItems(@QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading items.(offset=" + offset + ",limit=" + limit + ")."));
        org.dspace.core.Context context = null;
        ArrayList<Item> items = null;
        try {
            context = ItemsResource.createContext((EPerson)ItemsResource.getUser((HttpHeaders)headers));
            ItemIterator dspaceItems = org.dspace.content.Item.findAllUnfiltered((org.dspace.core.Context)context);
            items = new ArrayList<Item>();
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn((Object)"Pagging was badly set, using default values.");
                limit = 100;
                offset = 0;
            }
            for (int i = 0; dspaceItems.hasNext() && i < limit + offset; ++i) {
                org.dspace.content.Item dspaceItem = dspaceItems.next();
                if (i < offset || !ItemService.isItemListedForUser((org.dspace.core.Context)context, (org.dspace.content.Item)dspaceItem)) continue;
                items.add(new Item(dspaceItem, expand, context));
                this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.VIEW, user_ip, user_agent, xforwarderfor, headers, request, context);
            }
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Something went wrong while reading items from database. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Something went wrong while reading items, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)"Items were successfully read.");
        return items.toArray(new Item[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{item_id}/metadata")
    @Produces(value={"application/json", "application/xml"})
    public MetadataEntry[] getItemMetadata(@PathParam(value="item_id") Integer itemId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading item(id=" + itemId + ") metadata."));
        org.dspace.core.Context context = null;
        List metadata = null;
        try {
            context = ItemsResource.createContext((EPerson)ItemsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId.intValue(), 0);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.VIEW, user_ip, user_agent, xforwarderfor, headers, request, context);
            metadata = new Item(dspaceItem, "metadata", context).getMetadata();
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)("Item(id=" + itemId + ") metadata were successfully read."));
        return metadata.toArray(new MetadataEntry[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{item_id}/bitstreams")
    @Produces(value={"application/json", "application/xml"})
    public Bitstream[] getItemBitstreams(@PathParam(value="item_id") Integer itemId, @QueryParam(value="limit") @DefaultValue(value="20") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading item(id=" + itemId + ") bitstreams.(offset=" + offset + ",limit=" + limit + ")"));
        org.dspace.core.Context context = null;
        List bitstreams = null;
        try {
            context = ItemsResource.createContext((EPerson)ItemsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId.intValue(), 0);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.VIEW, user_ip, user_agent, xforwarderfor, headers, request, context);
            List itemBitstreams = new Item(dspaceItem, "bitstreams", context).getBitstreams();
            bitstreams = offset + limit > itemBitstreams.size() - offset ? itemBitstreams.subList(offset, itemBitstreams.size()) : itemBitstreams.subList(offset, offset + limit);
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + ") bitstreams, SQLExcpetion. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not read item(id=" + itemId + ") bitstreams, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)("Item(id=" + itemId + ") bitstreams were successfully read."));
        return bitstreams.toArray(new Bitstream[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{item_id}/metadata")
    @Consumes(value={"application/json", "application/xml"})
    public Response addItemMetadata(@PathParam(value="item_id") Integer itemId, List<MetadataEntry> metadata, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Adding metadata to item(id=" + itemId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = ItemsResource.createContext((EPerson)ItemsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId.intValue(), 1);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwarderfor, headers, request, context);
            for (MetadataEntry entry : metadata) {
                String[] data = this.mySplit(entry.getKey());
                if (data.length < 2 || data.length > 3) continue;
                dspaceItem.addMetadata(data[0], data[1], data[2], entry.getLanguage(), entry.getValue());
            }
            dspaceItem.update();
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not write metadata to item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            ItemsResource.processException((String)("Could not write metadata to item(id=" + itemId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not write metadata to item(id=" + itemId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Metadata to item(id=" + itemId + ") were successfully added."));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{item_id}/bitstreams")
    public Bitstream addItemBitstream(@PathParam(value="item_id") Integer itemId, InputStream inputStream, @QueryParam(value="name") String name, @QueryParam(value="description") String description, @QueryParam(value="groupId") Integer groupId, @QueryParam(value="year") Integer year, @QueryParam(value="month") Integer month, @QueryParam(value="day") Integer day, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Adding bitstream to item(id=" + itemId + ")."));
        org.dspace.core.Context context = null;
        Bitstream bitstream = null;
        try {
            context = ItemsResource.createContext((EPerson)ItemsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId.intValue(), 1);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwarderfor, headers, request, context);
            log.trace((Object)"Creating bitstream in item.");
            Bundle bundle = null;
            org.dspace.content.Bitstream dspaceBitstream = null;
            if (dspaceItem.getBundles().length == 0 || dspaceItem.getBundles() == null) {
                log.trace((Object)"Creating bundle in item.");
                dspaceBitstream = dspaceItem.createSingleBitstream(inputStream);
            } else {
                log.trace((Object)"Getting bundle from item.");
                bundle = dspaceItem.getBundles()[0];
                dspaceBitstream = bundle.createBitstream(inputStream);
            }
            dspaceBitstream.setSource("DSpace Rest api");
            if (name != null) {
                if (BitstreamResource.getMimeType((String)name) == null) {
                    dspaceBitstream.setFormat(BitstreamFormat.findUnknown((org.dspace.core.Context)context));
                } else {
                    dspaceBitstream.setFormat(BitstreamFormat.findByMIMEType((org.dspace.core.Context)context, (String)BitstreamResource.getMimeType((String)name)));
                }
                dspaceBitstream.setName(name);
            }
            if (description != null) {
                dspaceBitstream.setDescription(description);
            }
            dspaceBitstream.update();
            if (groupId != null) {
                Bundle[] bundles;
                for (Bundle dspaceBundle : bundles = dspaceBitstream.getBundles()) {
                    List bitstreamsPolicies = dspaceBundle.getBitstreamPolicies();
                    ArrayList<ResourcePolicy> policiesToRemove = new ArrayList<ResourcePolicy>();
                    for (ResourcePolicy policy : bitstreamsPolicies) {
                        if (policy.getResourceID() != dspaceBitstream.getID()) continue;
                        policiesToRemove.add(policy);
                    }
                    for (ResourcePolicy policy : policiesToRemove) {
                        bitstreamsPolicies.remove(policy);
                    }
                    ResourcePolicy dspacePolicy = ResourcePolicy.create((org.dspace.core.Context)context);
                    dspacePolicy.setAction(0);
                    dspacePolicy.setGroup(Group.find((org.dspace.core.Context)context, (int)groupId));
                    dspacePolicy.setResourceID(dspaceBitstream.getID());
                    dspacePolicy.setResource((DSpaceObject)dspaceBitstream);
                    dspacePolicy.setResourceType(0);
                    if (year != null || month != null || day != null) {
                        Date date = new Date();
                        if (year != null) {
                            date.setYear(year - 1900);
                        }
                        if (month != null) {
                            date.setMonth(month - 1);
                        }
                        if (day != null) {
                            date.setDate(day);
                        }
                        date.setHours(0);
                        date.setMinutes(0);
                        date.setSeconds(0);
                        dspacePolicy.setStartDate(date);
                    }
                    dspacePolicy.update();
                    bitstreamsPolicies.add(dspacePolicy);
                    dspaceBundle.replaceAllBitstreamPolicies(bitstreamsPolicies);
                    dspaceBundle.update();
                }
            }
            dspaceBitstream = org.dspace.content.Bitstream.find((org.dspace.core.Context)context, (int)dspaceBitstream.getID());
            bitstream = new Bitstream(dspaceBitstream, "");
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not create bitstream in item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            ItemsResource.processException((String)("Could not create bitstream in item(id=" + itemId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            ItemsResource.processException((String)("Could not create bitstream in item(id=" + itemId + "), IOException Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not create bitstream in item(id=" + itemId + "), ContextException Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Bitstream(id=" + bitstream.getId() + ") was successfully added into item(id=" + itemId + ")."));
        return bitstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{item_id}/metadata")
    @Consumes(value={"application/json", "application/xml"})
    public Response updateItemMetadata(@PathParam(value="item_id") Integer itemId, MetadataEntry[] metadata, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Updating metadata in item(id=" + itemId + ")."));
        org.dspace.core.Context context = null;
        try {
            String[] data;
            context = ItemsResource.createContext((EPerson)ItemsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId.intValue(), 1);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwarderfor, headers, request, context);
            log.trace((Object)"Deleting original metadata from item.");
            for (MetadataEntry entry : metadata) {
                data = this.mySplit(entry.getKey());
                if (data.length < 2 || data.length > 3) continue;
                dspaceItem.clearMetadata(data[0], data[1], data[2], "*");
            }
            log.trace((Object)"Adding new metadata to item.");
            for (MetadataEntry entry : metadata) {
                data = this.mySplit(entry.getKey());
                if (data.length < 2 || data.length > 3) continue;
                dspaceItem.addMetadata(data[0], data[1], data[2], entry.getLanguage(), entry.getValue());
            }
            dspaceItem.update();
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not update metadata in item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            ItemsResource.processException((String)("Could not update metadata in item(id=" + itemId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not update metadata in item(id=" + itemId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Metadata of item(id=" + itemId + ") were successfully updated."));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{item_id}")
    public Response deleteItem(@PathParam(value="item_id") Integer itemId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Deleting item(id=" + itemId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = ItemsResource.createContext((EPerson)ItemsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId.intValue(), 2);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.REMOVE, user_ip, user_agent, xforwarderfor, headers, request, context);
            log.trace((Object)"Deleting item.");
            Collection collection = Collection.find((org.dspace.core.Context)context, (int)dspaceItem.getCollections()[0].getID());
            collection.removeItem(dspaceItem);
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), IOException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Item(id=" + itemId + ") was successfully deleted."));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{item_id}/metadata")
    public Response deleteItemMetadata(@PathParam(value="item_id") Integer itemId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Deleting metadata in item(id=" + itemId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = ItemsResource.createContext((EPerson)ItemsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Item dspaceItem = this.findItem(context, itemId.intValue(), 1);
            this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwarderfor, headers, request, context);
            log.trace((Object)"Deleting metadata.");
            Metadatum[] value = dspaceItem.getMetadata("dc", "date", "accessioned", "*");
            Metadatum[] value2 = dspaceItem.getMetadata("dc", "date", "available", "*");
            Metadatum[] value3 = dspaceItem.getMetadata("dc", "identifier", "uri", "*");
            Metadatum[] value4 = dspaceItem.getMetadata("dc", "description", "provenance", "*");
            dspaceItem.clearMetadata("*", "*", "*", "*");
            dspaceItem.update();
            dspaceItem.addMetadata(value[0].schema, value[0].element, value[0].qualifier, null, value[0].value);
            dspaceItem.addMetadata(value2[0].schema, value2[0].element, value2[0].qualifier, null, value2[0].value);
            dspaceItem.addMetadata(value3[0].schema, value3[0].element, value3[0].qualifier, null, value3[0].value);
            dspaceItem.addMetadata(value4[0].schema, value4[0].element, value4[0].qualifier, null, value4[0].value);
            dspaceItem.update();
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), AuthorizeExcpetion. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not delete item(id=" + itemId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Item(id=" + itemId + ") metadata were successfully deleted."));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{item_id}/bitstreams/{bitstream_id}")
    public Response deleteItemBitstream(@PathParam(value="item_id") Integer itemId, @PathParam(value="bitstream_id") Integer bitstreamId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Deleting bitstream in item(id=" + itemId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = ItemsResource.createContext((EPerson)ItemsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Item item = this.findItem(context, itemId.intValue(), 1);
            org.dspace.content.Bitstream bitstream = org.dspace.content.Bitstream.find((org.dspace.core.Context)context, (int)bitstreamId);
            if (bitstream == null) {
                context.abort();
                log.warn((Object)("Bitstream(id=" + bitstreamId + ") was not found."));
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)bitstream, (int)2)) {
                context.abort();
                log.error((Object)("User(" + ItemsResource.getUser((HttpHeaders)headers).getEmail() + ") is not allowed to delete bitstream(id=" + bitstreamId + ")."));
                Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                return response;
            }
            this.writeStats((DSpaceObject)item, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwarderfor, headers, request, context);
            this.writeStats((DSpaceObject)bitstream, UsageEvent.Action.REMOVE, user_ip, user_agent, xforwarderfor, headers, request, context);
            log.trace((Object)"Deleting bitstream...");
            for (Bundle bundle : item.getBundles()) {
                for (org.dspace.content.Bitstream bit : bundle.getBitstreams()) {
                    if (bit != bitstream) continue;
                    bundle.removeBitstream(bitstream);
                }
            }
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            ItemsResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            ItemsResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), IOException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Could not delete bitstream(id=" + bitstreamId + "), ContextException. Message:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Bitstream(id=" + bitstreamId + ") from item(id=" + itemId + ") was successfuly deleted ."));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/find-by-metadata-field")
    @Produces(value={"application/json", "application/xml"})
    public Item[] findItemsByMetadataField(MetadataEntry metadataEntry, @QueryParam(value="expand") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Looking for item with metadata(key=" + metadataEntry.getKey() + ",value=" + metadataEntry.getValue() + ", language=" + metadataEntry.getLanguage() + ")."));
        org.dspace.core.Context context = null;
        ArrayList<Item> items = new ArrayList<Item>();
        String[] metadata = this.mySplit(metadataEntry.getKey());
        try {
            context = ItemsResource.createContext((EPerson)ItemsResource.getUser((HttpHeaders)headers));
            if (metadata.length < 2 || metadata.length > 3) {
                context.abort();
                log.error((Object)"Finding failed, bad metadata key.");
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            String sql = "SELECT ITEM_ID, TEXT_VALUE, TEXT_LANG, SHORT_ID, ELEMENT, QUALIFIER FROM METADATAVALUE JOIN METADATAFIELDREGISTRY ON METADATAVALUE.METADATA_FIELD_ID = METADATAFIELDREGISTRY.METADATA_FIELD_ID JOIN METADATASCHEMAREGISTRY ON METADATAFIELDREGISTRY.METADATA_SCHEMA_ID = METADATASCHEMAREGISTRY.METADATA_SCHEMA_ID WHERE SHORT_ID='" + metadata[0] + "'  AND " + "ELEMENT='" + metadata[1] + "' AND ";
            if (metadata.length > 3) {
                sql = sql + "QUALIFIER='" + metadata[2] + "' AND ";
            }
            sql = sql + "dbms_lob.substr(TEXT_VALUE, 40)='" + metadataEntry.getValue() + "' AND ";
            sql = metadataEntry.getLanguage() != null ? sql + "TEXT_LANG='" + metadataEntry.getLanguage() + "'" : sql + "TEXT_LANG is null";
            TableRowIterator iterator = DatabaseManager.query((org.dspace.core.Context)context, (String)sql, (Object[])new Object[0]);
            while (iterator.hasNext()) {
                TableRow row = iterator.next();
                org.dspace.content.Item dspaceItem = this.findItem(context, row.getIntColumn("ITEM_ID"), 0);
                Item item = new Item(dspaceItem, "", context);
                this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.VIEW, user_ip, user_agent, xforwarderfor, headers, request, context);
                items.add(item);
            }
            context.complete();
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Something get wrong while finding item. SQLException, Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            ItemsResource.processException((String)("Context error:" + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        if (items.size() == 0) {
            log.info((Object)"Items not found.");
        } else {
            log.info((Object)"Items were found.");
        }
        return items.toArray(new Item[0]);
    }

    private org.dspace.content.Item findItem(org.dspace.core.Context context, int id, int action) throws WebApplicationException {
        org.dspace.content.Item item = null;
        try {
            item = org.dspace.content.Item.find((org.dspace.core.Context)context, (int)id);
            if (item == null) {
                context.abort();
                log.warn((Object)("Item(id=" + id + ") was not found!"));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)item, (int)action)) {
                context.abort();
                if (context.getCurrentUser() != null) {
                    log.error((Object)("User(" + context.getCurrentUser().getEmail() + ") has not permission to " + this.getActionString(action) + " item!"));
                } else {
                    log.error((Object)("User(anonymous) has not permission to " + this.getActionString(action) + " item!"));
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        catch (SQLException e) {
            ItemsResource.processException((String)("Something get wrong while finding item(id=" + id + "). SQLException, Message: " + e), (org.dspace.core.Context)context);
        }
        return item;
    }
}

