/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.eperson.EPerson;
import org.dspace.rest.Resource;
import org.dspace.rest.TokenHolder;
import org.dspace.rest.common.Status;
import org.dspace.rest.common.User;
import org.dspace.rest.exceptions.ContextException;

@Path(value="/")
public class RestIndex {
    private static Logger log = Logger.getLogger(RestIndex.class);
    @Context
    public static ServletContext servletContext;

    @GET
    @Produces(value={"text/html"})
    public String sayHtmlHello() {
        return "<html><title>DSpace REST - index</title><body><h1>DSpace REST API</h1>Server path: " + servletContext.getContextPath() + "<h2>Index</h2>" + "<ul>" + "<li>GET / - It returns this page.</li>" + "<li>GET /test - Return string \"REST api is running\". It is method for testing.</li>" + "<li>POST /login - Method for login into DSpace RESTful api. You must post User class. Example: {\"email\":\"test@dspace\",\"password\":\"pass\"}. It returns token under which will must sending requests. In header \"rest-dspace-token\"</li>" + "<li>POST /logout - Method for logout from DSpace RESTful api. You must post request with header \"rest-dspace-token\" token</li>" + "</ul>" + "<h2>Communities</h2>" + "<ul>" + "<li>GET /communities - Returns array of all communities in DSpace.</li>" + "<li>GET /communities/top-communities - Returns array of all top communities in DSpace.</li>" + "<li>GET /communities/{communityId} - Returns community.</li>" + "<li>GET /communities/{communityId}/collections - Returns array of collections of community.</li>" + "<li>GET /communities/{communityId}/communities - Returns array of subcommunities of community.</li>" + "<li>POST /communities - Create new community at top level. You must post community.</li>" + "<li>POST /communities/{communityId}/collections - Create new collections in community. You must post collection.</li>" + "<li>POST /communities/{communityId}/communities - Create new subcommunity in community. You must post community.</li>" + "<li>PUT /communities/{communityId} - Update community.</li>" + "<li>DELETE /communities/{communityId} - Delete community.</li>" + "<li>DELETE /communities/{communityId}/collections/{collectionId} - Delete collection in community.</li>" + "<li>DELETE /communities/{communityId}/communities/{communityId2} - Delete subcommunity in community.</li>" + "</ul>" + "<h2>Collections</h2>" + "<ul>" + "<li>GET /collections - Return all collections of DSpace in array.</li>" + "<li>GET /collections/{collectionId} - Return collection with id.</li>" + "<li>GET /collections/{collectionId}/items - Return all items of collection.</li>" + "<li>POST /collections/{collectionId}/items - Create posted item in collection.</li>" + "<li>POST /collections/find-collection - Find collection by passed name.</li>" + "<li>PUT /collections/{collectionId} </li> - Update collection. You muset post collection." + "<li>DELETE /collections/{collectionId} - Delete collection from DSpace.</li>" + "<li>DELETE /collections/{collectionId}/items/{itemId} - Delete item in collection. </li>" + "</ul>" + "<h2>Items</h2>" + "<ul>" + "<li>GET /items - Return list of items.</li>" + "<li>GET /items/{item id} - Return item.</li>" + "<li>GET /items/{item id}/metadata - Return item metadata.</li>" + "<li>GET /items/{item id}/bitstreams - Return item bitstreams.</li>" + "<li>POST /items/find-by-metadata-field - Find items by metadata entry.</li>" + "<li>POST /items/{item id}/metadata - Add metadata to item.</li>" + "<li>POST /items/{item id}/bitstreams - Add bitstream to item.</li>" + "<li>PUT /items/{item id}/metadata - Update metadata in item.</li>" + "<li>DELETE /items/{item id} - Delete item.</li>" + "<li>DELETE /items/{item id}/metadata - Clear item metadata.</li>" + "<li>DELETE /items/{item id}/bitstreams/{bitstream id} - Delete item bitstream.</li>" + "</ul>" + "<h2>Bitstreams</h2>" + "<ul>" + "<li>GET /bitstreams - Return all bitstreams in DSpace.</li>" + "<li>GET /bitstreams/{bitstream id} - Return bitstream.</li>" + "<li>GET /bitstreams/{bitstream id}/policy - Return bitstream policies.</li>" + "<li>POST /bitstreams/{bitstream id}/retrieve - Return data of bitstream.</li>" + "<li>POST /bitstreams/{bitstream id}/policy - Add policy to item.</li>" + "<li>PUT /bitstreams/{bitstream id}/data - Update data of bitstream.</li>" + "<li>PUT /bitstreams/{bitstream id} - Update metadata of bitstream.</li>" + "<li>DELETE /bitstreams/{bitstream id} - Delete bitstream from DSpace.</li>" + "<li>DELETE /bitstreams/{bitstream id}/policy/{policy_id} - Delete bitstream policy.</li>" + "</ul>" + "</body></html> ";
    }

    @GET
    @Path(value="/test")
    public String test() {
        return "REST api is running.";
    }

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json", "application/xml"})
    public Response login(User user) {
        String token = TokenHolder.login((User)user);
        if (token == null) {
            log.info((Object)("REST Login Attempt failed for user: " + user.getEmail()));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        log.info((Object)("REST Login Success for user: " + user.getEmail()));
        return Response.ok((Object)token, (String)"text/plain").build();
    }

    @POST
    @Path(value="/logout")
    @Consumes(value={"application/json", "application/xml"})
    public Response logout(@Context HttpHeaders headers) {
        List list = headers.getRequestHeader(TokenHolder.TOKEN_HEADER);
        String token = null;
        boolean logout = false;
        EPerson ePerson = null;
        if (list != null) {
            token = (String)list.get(0);
            ePerson = TokenHolder.getEPerson((String)token);
            logout = TokenHolder.logout((String)token);
        }
        if (token == null || !logout) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (ePerson != null) {
            log.info((Object)("REST Logout: " + ePerson.getEmail()));
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/status")
    @Consumes(value={"application/json", "application/xml"})
    public Status status(@Context HttpHeaders headers) throws UnsupportedEncodingException {
        org.dspace.core.Context context = null;
        try {
            context = Resource.createContext((EPerson)Resource.getUser((HttpHeaders)headers));
            EPerson ePerson = context.getCurrentUser();
            if (ePerson != null) {
                Status status;
                EPerson dbEPerson = EPerson.findByEmail((org.dspace.core.Context)context, (String)ePerson.getEmail());
                String token = Resource.getToken((HttpHeaders)headers);
                Status status2 = status = new Status(dbEPerson.getEmail(), dbEPerson.getFullName(), token);
                return status2;
            }
        }
        catch (ContextException e) {
            Resource.processException((String)("Status context error: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (SQLException e) {
            Resource.processException((String)("Status eperson db lookup error: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            Resource.processException((String)("Status eperson authorize exception: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            context.abort();
        }
        return new Status();
    }
}

