/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.content.service.SiteService;
import org.dspace.rest.Resource;
import org.dspace.rest.common.ItemFilter;
import org.dspace.rest.common.ItemFilterQuery;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.rest.filter.ItemFilterSet;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.usage.UsageEvent;

@Path(value="/filtered-items")
public class FilteredItemsResource
extends Resource {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    protected MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected SiteService siteService = ContentServiceFactory.getInstance().getSiteService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private static Logger log = LogManager.getLogger(FilteredItemsResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/xml"})
    public ItemFilter getItemQuery(@QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @QueryParam(value="filters") @DefaultValue(value="is_item,all_filters") String filters, @QueryParam(value="query_field[]") @DefaultValue(value="dc.title") List<String> query_field, @QueryParam(value="query_op[]") @DefaultValue(value="exists") List<String> query_op, @QueryParam(value="query_val[]") @DefaultValue(value="") List<String> query_val, @QueryParam(value="collSel[]") @DefaultValue(value="") List<String> collSel, @Context HttpHeaders headers, @Context HttpServletRequest request, @Context ServletContext servletContext) {
        org.dspace.core.Context context = null;
        ItemFilterSet itemFilterSet = new ItemFilterSet(filters, true);
        ItemFilter result = itemFilterSet.getAllFiltersFilter();
        try {
            context = FilteredItemsResource.createContext();
            int index = Math.min(query_field.size(), Math.min(query_op.size(), query_val.size()));
            ArrayList<ItemFilterQuery> itemFilterQueries = new ArrayList<ItemFilterQuery>();
            for (int i = 0; i < index; ++i) {
                itemFilterQueries.add(new ItemFilterQuery(query_field.get(i), query_op.get(i), query_val.get(i)));
            }
            String regexClause = this.configurationService.getProperty("rest.regex-clause");
            if (regexClause == null) {
                regexClause = "";
            }
            List<UUID> uuids = this.getUuidsFromStrings(collSel);
            List<List<MetadataField>> listFieldList = this.getMetadataFieldsList(context, query_field);
            Iterator childItems = this.itemService.findByMetadataQuery(context, listFieldList, query_op, query_val, uuids, regexClause, offset.intValue(), limit.intValue());
            int count = itemFilterSet.processSaveItems(context, servletContext, childItems, true, expand);
            this.writeStats((DSpaceObject)this.siteService.findSite(context), UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            result.annotateQuery(query_field, query_op, query_val);
            result.setUnfilteredItemCount(count);
            context.complete();
        }
        catch (IOException e) {
            FilteredItemsResource.processException(e.getMessage(), context);
        }
        catch (SQLException e) {
            FilteredItemsResource.processException(e.getMessage(), context);
        }
        catch (AuthorizeException e) {
            FilteredItemsResource.processException(e.getMessage(), context);
        }
        catch (ContextException e) {
            FilteredItemsResource.processException("Unauthorized filtered item query. " + e.getMessage(), context);
        }
        finally {
            this.processFinally(context);
        }
        return result;
    }

    private List<List<MetadataField>> getMetadataFieldsList(org.dspace.core.Context context, List<String> query_field) throws SQLException {
        ArrayList<List<MetadataField>> listFieldList = new ArrayList<List<MetadataField>>();
        for (String s : query_field) {
            ArrayList<MetadataField> fields = new ArrayList<MetadataField>();
            listFieldList.add(fields);
            if (s.equals("*")) continue;
            String schema = "";
            String element = "";
            String qualifier = null;
            String[] parts = s.split("\\.");
            if (parts.length > 0) {
                schema = parts[0];
            }
            if (parts.length > 1) {
                element = parts[1];
            }
            if (parts.length > 2) {
                qualifier = parts[2];
            }
            if ("*".equals(qualifier)) {
                for (MetadataField mf : this.metadataFieldService.findFieldsByElementNameUnqualified(context, schema, element)) {
                    fields.add(mf);
                }
                continue;
            }
            MetadataField mf = this.metadataFieldService.findByElement(context, schema, element, qualifier);
            if (mf == null) continue;
            fields.add(mf);
        }
        return listFieldList;
    }

    private List<UUID> getUuidsFromStrings(List<String> collSel) {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (String s : collSel) {
            try {
                uuids.add(UUID.fromString(s));
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid collection UUID: " + s);
            }
        }
        return uuids;
    }
}

