/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

@XmlRootElement(name="resourcepolicy")
public class ResourcePolicy {
    private Integer id;
    private Action action;
    private String epersonId;
    private String groupId;
    private String resourceId;
    private String resourceType;
    private String rpDescription;
    private String rpName;
    private String rpType;
    private Date startDate;
    private Date endDate;

    public ResourcePolicy() {
    }

    public ResourcePolicy(org.dspace.authorize.ResourcePolicy dspacePolicy) {
        Group group;
        this.id = dspacePolicy.getID();
        switch (dspacePolicy.getAction()) {
            case 0: {
                this.action = Action.READ;
                break;
            }
            case 1: {
                this.action = Action.WRITE;
                break;
            }
            case 2: {
                this.action = Action.DELETE;
                break;
            }
        }
        EPerson ePerson = dspacePolicy.getEPerson();
        if (ePerson != null) {
            this.epersonId = ePerson.getID().toString();
        }
        if ((group = dspacePolicy.getGroup()) != null) {
            this.groupId = group.getID().toString();
        }
        this.resourceId = dspacePolicy.getdSpaceObject().getID().toString();
        this.rpDescription = dspacePolicy.getRpDescription();
        this.rpName = dspacePolicy.getRpName();
        this.rpType = dspacePolicy.getRpType();
        this.startDate = dspacePolicy.getStartDate();
        this.endDate = dspacePolicy.getEndDate();
        switch (dspacePolicy.getdSpaceObject().getType()) {
            case 0: {
                this.resourceType = "bitstream";
                break;
            }
            case 2: {
                this.resourceType = "item";
                break;
            }
            case 3: {
                this.resourceType = "collection";
                break;
            }
            case 4: {
                this.resourceType = "community";
                break;
            }
            case 1: {
                this.resourceType = "bundle";
                break;
            }
            default: {
                this.resourceType = "";
            }
        }
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Action getAction() {
        return this.action;
    }

    @JsonIgnore
    public int getActionInt() {
        switch (this.action) {
            case READ: {
                return 0;
            }
            case WRITE: {
                return 1;
            }
            case DELETE: {
                return 2;
            }
        }
        return 0;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getEpersonId() {
        return this.epersonId;
    }

    public void setEpersonId(String epersonId) {
        this.epersonId = epersonId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getRpDescription() {
        return this.rpDescription;
    }

    public void setRpDescription(String rpDescription) {
        this.rpDescription = rpDescription;
    }

    public String getRpName() {
        return this.rpName;
    }

    public void setRpName(String rpName) {
        this.rpName = rpName;
    }

    public String getRpType() {
        return this.rpType;
    }

    public void setRpType(String rpType) {
        this.rpType = rpType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public static enum Action {
        READ,
        WRITE,
        DELETE;

    }
}

