/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.filter;

import java.util.List;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.rest.filter.ItemFilterDefs;
import org.dspace.rest.filter.ItemFilterList;
import org.dspace.rest.filter.ItemFilterTest;
import org.dspace.rest.filter.ItemFilterUtil;
import org.dspace.services.factory.DSpaceServicesFactory;

public class ItemFilterDefsMisc
implements ItemFilterList {
    public static final String CAT_MISC = "Bitstream Bundle Filters";
    public static final String CAT_MIME_SUPP = "Supported MIME Type Filters";

    @Override
    public ItemFilterTest[] getFilters() {
        return EnumItemFilterDefs.values();
    }

    private static enum EnumItemFilterDefs implements ItemFilterTest
    {
        has_only_supp_image_type("Item Image Bitstreams are Supported", null, "Supported MIME Type Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                int imageCount = ItemFilterUtil.countOriginalBitstreamMimeStartsWith(context, item, "image/");
                if (imageCount == 0) {
                    return false;
                }
                int suppImageCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getSupportedImageMimeTypes());
                return imageCount == suppImageCount;
            }
        }
        ,
        has_unsupp_image_type("Item has Image Bitstream that is Unsupported", null, "Supported MIME Type Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                int imageCount = ItemFilterUtil.countOriginalBitstreamMimeStartsWith(context, item, "image/");
                if (imageCount == 0) {
                    return false;
                }
                int suppImageCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getSupportedImageMimeTypes());
                return imageCount - suppImageCount > 0;
            }
        }
        ,
        has_only_supp_doc_type("Item Document Bitstreams are Supported", null, "Supported MIME Type Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                int docCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getDocumentMimeTypes());
                if (docCount == 0) {
                    return false;
                }
                int suppDocCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getSupportedDocumentMimeTypes());
                return docCount == suppDocCount;
            }
        }
        ,
        has_unsupp_doc_type("Item has Document Bitstream that is Unsupported", null, "Supported MIME Type Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                int docCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getDocumentMimeTypes());
                if (docCount == 0) {
                    return false;
                }
                int suppDocCount = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getSupportedDocumentMimeTypes());
                return docCount - suppDocCount > 0;
            }
        }
        ,
        has_small_pdf("Has unusually small PDF", null, "Bitstream Filters by MIME Type"){

            @Override
            public boolean testItem(Context context, Item item) {
                return ItemFilterUtil.countBitstreamSmallerThanMinSize(context, ItemFilterUtil.BundleName.ORIGINAL, item, ItemFilterDefs.MIMES_PDF, "rest.report-pdf-min-size") > 0;
            }
        }
        ,
        has_large_pdf("Has unusually large PDF", null, "Bitstream Filters by MIME Type"){

            @Override
            public boolean testItem(Context context, Item item) {
                return ItemFilterUtil.countBitstreamLargerThanMaxSize(context, ItemFilterUtil.BundleName.ORIGINAL, item, ItemFilterDefs.MIMES_PDF, "rest.report-pdf-max-size") > 0;
            }
        }
        ,
        has_unsupported_bundle("Has bitstream in an unsuppored bundle", null, "Bitstream Bundle Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                String[] bundleList = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("rest.report-supp-bundles");
                return ItemFilterUtil.hasUnsupportedBundle(item, bundleList);
            }
        }
        ,
        has_small_thumbnail("Has unusually small thumbnail", null, "Bitstream Bundle Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                return ItemFilterUtil.countBitstreamSmallerThanMinSize(context, ItemFilterUtil.BundleName.THUMBNAIL, item, ItemFilterDefs.MIMES_JPG, "rest.report-thumbnail-min-size") > 0;
            }
        }
        ,
        has_doc_without_text("Has document bitstream without TEXT item", null, "Bitstream Filters by MIME Type"){

            @Override
            public boolean testItem(Context context, Item item) {
                int countDoc = ItemFilterUtil.countOriginalBitstreamMime(context, item, ItemFilterUtil.getDocumentMimeTypes());
                if (countDoc == 0) {
                    return false;
                }
                int countText = ItemFilterUtil.countBitstream(ItemFilterUtil.BundleName.TEXT, item);
                return countDoc > countText;
            }
        }
        ,
        has_original_without_thumbnail("Has original bitstream without thumbnail", null, "Bitstream Bundle Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                int countBit = ItemFilterUtil.countOriginalBitstream(item);
                if (countBit == 0) {
                    return false;
                }
                int countThumb = ItemFilterUtil.countBitstream(ItemFilterUtil.BundleName.THUMBNAIL, item);
                return countBit > countThumb;
            }
        }
        ,
        has_invalid_thumbnail_name("Has invalid thumbnail name (assumes one thumbnail for each original)", null, "Bitstream Bundle Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                List<String> originalNames = ItemFilterUtil.getBitstreamNames(ItemFilterUtil.BundleName.ORIGINAL, item);
                List<String> thumbNames = ItemFilterUtil.getBitstreamNames(ItemFilterUtil.BundleName.THUMBNAIL, item);
                if (thumbNames.size() != originalNames.size()) {
                    return false;
                }
                for (String name : originalNames) {
                    if (thumbNames.contains(name + ".jpg")) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        has_non_generated_thumb("Has non generated thumbnail", null, "Bitstream Bundle Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                String[] generatedThumbDesc = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("rest.report-gen-thumbnail-desc");
                int countThumb = ItemFilterUtil.countBitstream(ItemFilterUtil.BundleName.THUMBNAIL, item);
                if (countThumb == 0) {
                    return false;
                }
                int countGen = ItemFilterUtil.countBitstreamByDesc(ItemFilterUtil.BundleName.THUMBNAIL, item, generatedThumbDesc);
                return countThumb > countGen;
            }
        }
        ,
        no_license("Doesn't have a license", null, "Bitstream Bundle Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                return ItemFilterUtil.countBitstream(ItemFilterUtil.BundleName.LICENSE, item) == 0;
            }
        }
        ,
        has_license_documentation("Has documentation in the license bundle", null, "Bitstream Bundle Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                List<String> names = ItemFilterUtil.getBitstreamNames(ItemFilterUtil.BundleName.LICENSE, item);
                for (String name : names) {
                    if (name.equals("license.txt")) continue;
                    return true;
                }
                return false;
            }
        };

        private String title = null;
        private String description = null;
        private String category = null;

        private EnumItemFilterDefs(String title, String description, String category) {
            this.title = title;
            this.description = description;
            this.category = category;
        }

        private EnumItemFilterDefs() {
            this(null, null, null);
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getCategory() {
            return this.category;
        }
    }
}

