/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.filter;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.rest.filter.ItemFilterList;
import org.dspace.rest.filter.ItemFilterTest;
import org.dspace.rest.filter.ItemFilterUtil;

public class ItemFilterDefsPerm
implements ItemFilterList {
    protected static AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    public static final String CAT_PERM = "Perimission Filters";
    private static Logger log = LogManager.getLogger(ItemFilterDefsPerm.class);

    @Override
    public ItemFilterTest[] getFilters() {
        return EnumItemFilterPermissionDefs.values();
    }

    public static enum EnumItemFilterPermissionDefs implements ItemFilterTest
    {
        has_restricted_original("Item has Restricted Original Bitstream", "Item has at least one original bitstream that is not accessible to Anonymous user", "Perimission Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                try {
                    for (Bundle bundle : item.getBundles()) {
                        if (!bundle.getName().equals(ItemFilterUtil.BundleName.ORIGINAL.name())) continue;
                        for (Bitstream bit : bundle.getBitstreams()) {
                            if (authorizeService.authorizeActionBoolean(EnumItemFilterPermissionDefs.getAnonContext(), (DSpaceObject)bit, 0)) continue;
                            return true;
                        }
                    }
                }
                catch (SQLException e) {
                    log.warn("SQL Exception testing original bitstream access " + e.getMessage(), (Throwable)e);
                }
                return false;
            }
        }
        ,
        has_restricted_thumbnail("Item has Restricted Thumbnail", "Item has at least one thumbnail that is not accessible to Anonymous user", "Perimission Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                try {
                    for (Bundle bundle : item.getBundles()) {
                        if (!bundle.getName().equals(ItemFilterUtil.BundleName.THUMBNAIL.name())) continue;
                        for (Bitstream bit : bundle.getBitstreams()) {
                            if (authorizeService.authorizeActionBoolean(EnumItemFilterPermissionDefs.getAnonContext(), (DSpaceObject)bit, 0)) continue;
                            return true;
                        }
                    }
                }
                catch (SQLException e) {
                    log.warn("SQL Exception testing thumbnail bitstream access " + e.getMessage(), (Throwable)e);
                }
                return false;
            }
        }
        ,
        has_restricted_metadata("Item has Restricted Metadata", "Item has metadata that is not accessible to Anonymous user", "Perimission Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                try {
                    return !authorizeService.authorizeActionBoolean(EnumItemFilterPermissionDefs.getAnonContext(), (DSpaceObject)item, 0);
                }
                catch (SQLException e) {
                    log.warn("SQL Exception testing item metadata access " + e.getMessage(), (Throwable)e);
                    return false;
                }
            }
        };

        private static Context anonContext;
        private String title = null;
        private String description = null;
        private String category = null;

        private static Context getAnonContext() {
            if (anonContext == null) {
                anonContext = new Context();
            }
            return anonContext;
        }

        private EnumItemFilterPermissionDefs(String title, String description, String category) {
            this.title = title;
            this.description = description;
            this.category = category;
        }

        private EnumItemFilterPermissionDefs() {
            this(null, null, null);
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getCategory() {
            return this.category;
        }
    }
}

