/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class Resource {
    @Context
    public ServletContext servletContext;
    private static Logger log = LogManager.getLogger(Resource.class);
    private static final boolean writeStatistics = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("rest.stats", false);

    protected static org.dspace.core.Context createContext() throws ContextException, SQLException {
        org.dspace.core.Context context = new org.dspace.core.Context();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            Collection specialGroups = authentication.getAuthorities();
            for (SimpleGrantedAuthority grantedAuthority : specialGroups) {
                context.setSpecialGroup(EPersonServiceFactory.getInstance().getGroupService().findByName(context, grantedAuthority.getAuthority()).getID());
            }
            context.setCurrentUser(EPersonServiceFactory.getInstance().getEPersonService().findByEmail(context, authentication.getName()));
        }
        return context;
    }

    protected void writeStats(DSpaceObject dspaceObject, UsageEvent.Action action, String user_ip, String user_agent, String xforwardedfor, HttpHeaders headers, HttpServletRequest request, org.dspace.core.Context context) {
        if (!writeStatistics) {
            return;
        }
        if (user_ip == null || user_ip.length() == 0) {
            DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)new UsageEvent(action, request, context, dspaceObject));
        } else {
            DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)new UsageEvent(action, user_ip, user_agent, xforwardedfor, context, dspaceObject));
        }
        log.debug("fired event");
    }

    protected static void processException(String message, org.dspace.core.Context context) throws WebApplicationException {
        if (context != null && context.isValid()) {
            context.abort();
        }
        log.error(message);
        throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
    }

    protected void processFinally(org.dspace.core.Context context) throws WebApplicationException {
        if (context != null && context.isValid()) {
            context.abort();
            log.error("Something get wrong. Aborting context in finally statement.");
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected String[] mySplit(String key) {
        ArrayList<String> list = new ArrayList<String>();
        int prev = 0;
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) == '.') {
                list.add(key.substring(prev, i));
                prev = i + 1;
                continue;
            }
            if (i + 1 != key.length()) continue;
            list.add(key.substring(prev, i + 1));
        }
        if (list.size() == 2) {
            list.add(null);
        }
        return list.toArray(new String[0]);
    }

    protected String getActionString(int action) {
        String actionStr;
        switch (action) {
            case 0: {
                actionStr = "read";
                break;
            }
            case 1: {
                actionStr = "write";
                break;
            }
            case 2: {
                actionStr = "delete";
                break;
            }
            case 4: {
                actionStr = "remove";
                break;
            }
            case 3: {
                actionStr = "add";
                break;
            }
            default: {
                actionStr = "(?action?)";
            }
        }
        return actionStr;
    }
}

