/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.filter;

import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.rest.filter.ItemFilterList;
import org.dspace.rest.filter.ItemFilterTest;
import org.dspace.rest.filter.ItemFilterUtil;
import org.dspace.services.factory.DSpaceServicesFactory;

public class ItemFilterDefsMeta
implements ItemFilterList {
    protected static ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    static Logger log = LogManager.getLogger(ItemFilterDefsMeta.class);
    public static final String CAT_META_GEN = "General Metadata Filters";
    public static final String CAT_META_SPEC = "Specific Metadata Filters";
    public static final String CAT_MOD = "Recently Modified";

    @Override
    public ItemFilterTest[] getFilters() {
        return EnumItemFilterDefs.values();
    }

    private static enum EnumItemFilterDefs implements ItemFilterTest
    {
        has_no_title("Has no dc.title", null, "Specific Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                return itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.title").size() == 0;
            }
        }
        ,
        has_no_uri("Has no dc.identifier.uri", null, "Specific Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                return itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.identifier.uri").size() == 0;
            }
        }
        ,
        has_mult_uri("Has multiple dc.identifier.uri", null, "Specific Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                return itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.identifier.uri").size() > 1;
            }
        }
        ,
        has_compound_subject("Has compound subject", null, "Specific Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                String regex = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("rest.report-regex-compound-subject");
                return ItemFilterUtil.hasMetadataMatch(item, "dc.subject.*", Pattern.compile(regex));
            }
        }
        ,
        has_compound_author("Has compound author", null, "Specific Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                String regex = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("rest.report-regex-compound-author");
                return ItemFilterUtil.hasMetadataMatch(item, "dc.creator,dc.contributor.author", Pattern.compile(regex));
            }
        }
        ,
        has_empty_metadata("Has empty metadata", null, "General Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                return ItemFilterUtil.hasMetadataMatch(item, "*", Pattern.compile("^\\s*$"));
            }
        }
        ,
        has_unbreaking_metadata("Has unbreaking metadata", null, "General Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                String regex = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("rest.report-regex-unbreaking");
                return ItemFilterUtil.hasMetadataMatch(item, "*", Pattern.compile(regex));
            }
        }
        ,
        has_long_metadata("Has long metadata field", null, "General Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                String regex = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("rest.report-regex-long");
                return ItemFilterUtil.hasMetadataMatch(item, "*", Pattern.compile(regex));
            }
        }
        ,
        has_xml_entity("Has XML entity in metadata", null, "General Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                String regex = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("rest.report-regex-xml-entity");
                return ItemFilterUtil.hasMetadataMatch(item, "*", Pattern.compile(regex));
            }
        }
        ,
        has_non_ascii("Has non-ascii in metadata", null, "General Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                String regex = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("rest.report-regex-non-ascii");
                return ItemFilterUtil.hasMetadataMatch(item, "*", Pattern.compile(regex));
            }
        }
        ,
        has_desc_url("Has url in description", null, "Specific Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                String regex = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("rest.report-regex-url");
                return ItemFilterUtil.hasMetadataMatch(item, "dc.description.*", Pattern.compile(regex));
            }
        }
        ,
        has_fulltext_provenance("Has fulltext in provenance", null, "Specific Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                String regex = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("rest.report-regex-fulltext");
                return ItemFilterUtil.hasMetadataMatch(item, "dc.description.provenance", Pattern.compile(regex));
            }
        }
        ,
        no_fulltext_provenance("Doesn't have fulltext in provenance", null, "Specific Metadata Filters"){

            @Override
            public boolean testItem(Context context, Item item) {
                String regex = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("rest.report-regex-fulltext");
                return !ItemFilterUtil.hasMetadataMatch(item, "dc.description.provenance", Pattern.compile(regex));
            }
        }
        ,
        mod_last_day("Modified in last 1 day", null, "Recently Modified"){

            @Override
            public boolean testItem(Context context, Item item) {
                return ItemFilterUtil.recentlyModified(item, 1);
            }
        }
        ,
        mod_last_7_days("Modified in last 7 days", null, "Recently Modified"){

            @Override
            public boolean testItem(Context context, Item item) {
                return ItemFilterUtil.recentlyModified(item, 7);
            }
        }
        ,
        mod_last_30_days("Modified in last 30 days", null, "Recently Modified"){

            @Override
            public boolean testItem(Context context, Item item) {
                return ItemFilterUtil.recentlyModified(item, 30);
            }
        }
        ,
        mod_last_90_days("Modified in last 60 days", null, "Recently Modified"){

            @Override
            public boolean testItem(Context context, Item item) {
                return ItemFilterUtil.recentlyModified(item, 60);
            }
        };

        private String title = null;
        private String description = null;
        private String category = null;

        private EnumItemFilterDefs(String title, String description, String category) {
            this.title = title;
            this.description = description;
            this.category = category;
        }

        private EnumItemFilterDefs() {
            this(null, null, null);
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getCategory() {
            return this.category;
        }
    }
}

