/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.filter;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.rest.common.Item;
import org.dspace.rest.common.ItemFilter;

public class ItemFilterSet {
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    static Logger log = LogManager.getLogger(ItemFilterSet.class);
    private List<ItemFilter> itemFilters;
    private ItemFilter allFiltersFilter;

    public ItemFilterSet(String filterList, boolean reportItems) {
        log.debug(String.format("Create ItemFilterSet: %s", filterList));
        this.itemFilters = ItemFilter.getItemFilters(filterList, reportItems);
        this.allFiltersFilter = ItemFilter.getAllFiltersFilter(this.itemFilters);
    }

    public ItemFilter getAllFiltersFilter() {
        return this.allFiltersFilter;
    }

    public void testItem(Context context, org.dspace.content.Item item, Item restItem) {
        boolean bAllTrue = true;
        for (ItemFilter itemFilter : this.itemFilters) {
            if (!itemFilter.hasItemTest()) continue;
            bAllTrue &= itemFilter.testItem(context, item, restItem);
        }
        if (bAllTrue && this.allFiltersFilter != null) {
            this.allFiltersFilter.addItem(restItem);
        }
    }

    public List<ItemFilter> getItemFilters() {
        return this.itemFilters;
    }

    public int processSaveItems(Context context, ServletContext servletContext, Iterator<org.dspace.content.Item> childItems, boolean save, String expand) throws WebApplicationException, SQLException {
        return this.processSaveItems(context, servletContext, childItems, new ArrayList<Item>(), save, expand);
    }

    public int processSaveItems(Context context, ServletContext servletContext, Iterator<org.dspace.content.Item> childItems, List<Item> items, boolean save, String expand) throws WebApplicationException, SQLException {
        int count = 0;
        while (childItems.hasNext()) {
            ++count;
            org.dspace.content.Item item = childItems.next();
            log.debug(item.getHandle() + " evaluate.");
            if (this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 0)) {
                Item restItem = new Item(item, servletContext, expand, context);
                if (save) {
                    items.add(restItem);
                }
                this.testItem(context, item, restItem);
                continue;
            }
            log.debug(item.getHandle() + " not authorized - not included in result set.");
        }
        return count;
    }
}

