/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.factory.UtilServiceFactory;
import org.dspace.app.util.service.MetadataExposureService;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bundle;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.rest.common.Bitstream;
import org.dspace.rest.common.Collection;
import org.dspace.rest.common.Community;
import org.dspace.rest.common.DSpaceObject;
import org.dspace.rest.common.MetadataEntry;

@XmlRootElement(name="item")
public class Item
extends DSpaceObject {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected MetadataExposureService metadataExposureService = UtilServiceFactory.getInstance().getMetadataExposureService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    Logger log = LogManager.getLogger(Item.class);
    String isArchived;
    String isWithdrawn;
    String lastModified;
    Collection parentCollection;
    List<Collection> parentCollectionList;
    List<Community> parentCommunityList;
    List<MetadataEntry> metadata;
    List<Bitstream> bitstreams;

    public Item() {
    }

    public Item(org.dspace.content.Item item, ServletContext servletContext, String expand, Context context) throws SQLException, WebApplicationException {
        super((org.dspace.content.DSpaceObject)item, servletContext);
        this.setup(item, servletContext, expand, context);
    }

    private void setup(org.dspace.content.Item item, ServletContext servletContext, String expand, Context context) throws SQLException {
        List<Object> expandFields = new ArrayList();
        if (expand != null) {
            expandFields = Arrays.asList(expand.split(","));
        }
        if (expandFields.contains("metadata") || expandFields.contains("all")) {
            this.metadata = new ArrayList();
            List metadataValues = this.itemService.getMetadata((org.dspace.content.DSpaceObject)item, "*", "*", "*", "*");
            for (MetadataValue metadataValue : metadataValues) {
                MetadataField metadataField = metadataValue.getMetadataField();
                if (this.metadataExposureService.isHidden(context, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier())) continue;
                this.metadata.add(new MetadataEntry(metadataField.toString('.'), metadataValue.getValue(), metadataValue.getLanguage()));
            }
        } else {
            this.addExpand("metadata");
        }
        this.setArchived(Boolean.toString(item.isArchived()));
        this.setWithdrawn(Boolean.toString(item.isWithdrawn()));
        this.setLastModified(item.getLastModified().toString());
        if (expandFields.contains("parentCollection") || expandFields.contains("all")) {
            if (item.getOwningCollection() != null) {
                this.parentCollection = new Collection(item.getOwningCollection(), servletContext, null, context, null, null);
            } else {
                this.addExpand("parentCollection");
            }
        } else {
            this.addExpand("parentCollection");
        }
        if (expandFields.contains("parentCollectionList") || expandFields.contains("all")) {
            this.parentCollectionList = new ArrayList();
            List collections = item.getCollections();
            for (org.dspace.content.Collection collection : collections) {
                this.parentCollectionList.add(new Collection(collection, servletContext, null, context, null, null));
            }
        } else {
            this.addExpand("parentCollectionList");
        }
        if (expandFields.contains("parentCommunityList") || expandFields.contains("all")) {
            this.parentCommunityList = new ArrayList();
            List communities = this.itemService.getCommunities(context, item);
            for (org.dspace.content.Community community : communities) {
                this.parentCommunityList.add(new Community(community, servletContext, null, context));
            }
        } else {
            this.addExpand("parentCommunityList");
        }
        if (expandFields.contains("bitstreams") || expandFields.contains("all")) {
            this.bitstreams = new ArrayList();
            List bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                List itemBitstreams = bundle.getBitstreams();
                for (org.dspace.content.Bitstream itemBitstream : itemBitstreams) {
                    if (!this.authorizeService.authorizeActionBoolean(context, (org.dspace.content.DSpaceObject)itemBitstream, 0)) continue;
                    this.bitstreams.add(new Bitstream(itemBitstream, servletContext, null, context));
                }
            }
        } else {
            this.addExpand("bitstreams");
        }
        if (!expandFields.contains("all")) {
            this.addExpand("all");
        }
    }

    public String getArchived() {
        return this.isArchived;
    }

    public void setArchived(String archived) {
        this.isArchived = archived;
    }

    public String getWithdrawn() {
        return this.isWithdrawn;
    }

    public void setWithdrawn(String withdrawn) {
        this.isWithdrawn = withdrawn;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public Collection getParentCollection() {
        return this.parentCollection;
    }

    public List<Collection> getParentCollectionList() {
        return this.parentCollectionList;
    }

    public List<MetadataEntry> getMetadata() {
        return this.metadata;
    }

    public List<Bitstream> getBitstreams() {
        return this.bitstreams;
    }

    public List<Community> getParentCommunityList() {
        return this.parentCommunityList;
    }

    public void setParentCollection(Collection parentCollection) {
        this.parentCollection = parentCollection;
    }

    public void setParentCollectionList(List<Collection> parentCollectionList) {
        this.parentCollectionList = parentCollectionList;
    }

    public void setParentCommunityList(List<Community> parentCommunityList) {
        this.parentCommunityList = parentCommunityList;
    }

    @XmlElement(required=true)
    public void setMetadata(List<MetadataEntry> metadata) {
        this.metadata = metadata;
    }

    public void setBitstreams(List<Bitstream> bitstreams) {
        this.bitstreams = bitstreams;
    }
}

