/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.rest.common.Report;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

@Path(value="/reports")
public class RestReports {
    private static Logger log = LogManager.getLogger(RestReports.class);
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    public static final String REST_RPT_URL = "rest.report-url.";

    @GET
    @Produces(value={"application/xml"})
    public Report[] reportIndex() throws WebApplicationException {
        ArrayList<Report> reports = new ArrayList<Report>();
        List propNames = this.configurationService.getPropertyKeys("rest");
        for (String propName : propNames) {
            if (!propName.startsWith(REST_RPT_URL)) continue;
            String nickname = propName.substring(REST_RPT_URL.length());
            String url = this.configurationService.getProperty(propName);
            reports.add(new Report(nickname, url));
        }
        return reports.toArray(new Report[0]);
    }

    @Path(value="/{report_nickname}")
    @GET
    public Response customReport(@PathParam(value="report_nickname") String report_nickname, @Context UriInfo uriInfo) throws WebApplicationException {
        URI uri = null;
        if (!report_nickname.isEmpty()) {
            log.info(String.format("Seeking report %s", report_nickname));
            String url = this.configurationService.getProperty(REST_RPT_URL + report_nickname);
            log.info(String.format("URL for report %s found: [%s]", report_nickname, url));
            if (!url.isEmpty()) {
                uri = uriInfo.getBaseUriBuilder().path(url).build(new Object[]{""});
                log.info(String.format("URI for report %s", uri));
            }
        }
        if (uri != null) {
            return Response.temporaryRedirect(uri).build();
        }
        return Response.noContent().build();
    }
}

