/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueList;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.DSpaceObject;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DSpaceObjectConverter<M extends DSpaceObject, R extends DSpaceObjectRest>
implements DSpaceConverter<M, R> {
    @Autowired
    ConverterService converter;

    public R convert(M obj, Projection projection) {
        DSpaceObjectRest resource = this.newInstance();
        resource.setProjection(projection);
        resource.setHandle(obj.getHandle());
        if (obj.getID() != null) {
            resource.setUuid(obj.getID().toString());
        }
        resource.setName(obj.getName());
        MetadataValueList metadataValues = new MetadataValueList(obj.getMetadata());
        resource.setMetadata((MetadataRest)this.converter.toRest((Object)metadataValues, projection));
        return (R)resource;
    }

    protected abstract R newInstance();
}

