/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.io.Serializable;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.IndexableObjectConverter;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.PoolTaskRest;
import org.dspace.app.rest.model.WorkflowItemRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.discovery.IndexableObject;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PoolTaskConverter
implements IndexableObjectConverter<PoolTask, PoolTaskRest> {
    @Autowired
    private ConverterService converter;

    public PoolTaskRest convert(PoolTask obj, Projection projection) {
        PoolTaskRest taskRest = new PoolTaskRest();
        taskRest.setProjection(projection);
        XmlWorkflowItem witem = obj.getWorkflowItem();
        taskRest.setId((Serializable)obj.getID());
        taskRest.setWorkflowitem((WorkflowItemRest)this.converter.toRest((Object)witem, projection));
        if (obj.getEperson() != null) {
            taskRest.setEperson((EPersonRest)this.converter.toRest((Object)obj.getEperson(), projection));
        }
        if (obj.getGroup() != null) {
            taskRest.setGroup((GroupRest)this.converter.toRest((Object)obj.getGroup(), projection));
        }
        taskRest.setAction(obj.getActionID());
        taskRest.setStep(obj.getStepID());
        return taskRest;
    }

    public Class<PoolTask> getModelClass() {
        return PoolTask.class;
    }

    public boolean supportsModel(IndexableObject idxo) {
        return idxo.getIndexedObject() instanceof PoolTask;
    }
}

