/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.TemplateItemRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.model.wrapper.TemplateItem;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.app.rest.utils.CollectionRestEqualityUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="core.collection")
public class CollectionRestRepository
extends DSpaceObjectRestRepository<Collection, CollectionRest> {
    @Autowired
    CommunityService communityService;
    @Autowired
    CollectionRestEqualityUtils collectionRestEqualityUtils;
    @Autowired
    private CollectionService cs;
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    private ItemService itemService;

    public CollectionRestRepository(CollectionService dsoService) {
        super((DSpaceObjectService)dsoService);
    }

    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'READ')")
    public CollectionRest findOne(Context context, UUID id) {
        Collection collection = null;
        try {
            collection = (Collection)this.cs.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (collection == null) {
            return null;
        }
        return (CollectionRest)this.converter.toRest((Object)collection, this.utils.obtainProjection());
    }

    public Page<CollectionRest> findAll(Context context, Pageable pageable) {
        try {
            long total = this.cs.countTotal(context);
            List collections = this.cs.findAll(context, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            return this.converter.toRestPage(collections, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="findAuthorizedByCommunity")
    public Page<CollectionRest> findAuthorizedByCommunity(@Parameter(value="uuid", required=true) UUID communityUuid, Pageable pageable) {
        try {
            Context context = this.obtainContext();
            Community com = (Community)this.communityService.find(context, communityUuid);
            if (com == null) {
                throw new ResourceNotFoundException("core.community with id: " + communityUuid + " not found");
            }
            List collections = this.cs.findAuthorized(context, com, 3);
            return this.converter.toRestPage(this.utils.getPage(collections, pageable), this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="findAuthorized")
    public Page<CollectionRest> findAuthorized(Pageable pageable) {
        try {
            Context context = this.obtainContext();
            List collections = this.cs.findAuthorizedOptimized(context, 3);
            return this.converter.toRestPage(this.utils.getPage(collections, pageable), this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'WRITE')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    public Class<CollectionRest> getDomainClass() {
        return CollectionRest.class;
    }

    protected CollectionRest createAndReturn(Context context) throws AuthorizeException {
        throw new DSpaceBadRequestException("Cannot create a Collection without providing a parent Community.");
    }

    @PreAuthorize(value="hasPermission(#id, 'COMMUNITY', 'ADD')")
    protected CollectionRest createAndReturn(Context context, UUID id) throws AuthorizeException {
        Collection collection;
        CollectionRest collectionRest;
        if (id == null) {
            throw new DSpaceBadRequestException("Parent Community UUID is null. Cannot create a Collection without providing a parent Community");
        }
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        try {
            ServletInputStream input = req.getInputStream();
            collectionRest = (CollectionRest)mapper.readValue((InputStream)input, CollectionRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body.", (Throwable)e1);
        }
        try {
            Community parent = (Community)this.communityService.find(context, id);
            if (parent == null) {
                throw new UnprocessableEntityException("Parent community for id: " + id + " not found");
            }
            collection = this.cs.create(context, parent);
            this.cs.update(context, (DSpaceObject)collection);
            this.metadataConverter.setMetadata(context, (DSpaceObject)collection, collectionRest.getMetadata());
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to create new Collection under parent Community " + id, e);
        }
        return (CollectionRest)this.converter.toRest((Object)collection, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'WRITE')")
    protected CollectionRest put(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, JsonNode jsonNode) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        CollectionRest collectionRest;
        try {
            collectionRest = (CollectionRest)new ObjectMapper().readValue(jsonNode.toString(), CollectionRest.class);
        }
        catch (IOException e) {
            throw new UnprocessableEntityException("Error parsing collection json: " + e.getMessage());
        }
        Collection collection = (Collection)this.cs.find(context, id);
        if (collection == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        CollectionRest originalCollectionRest = (CollectionRest)this.converter.toRest((Object)collection, this.utils.obtainProjection());
        if (!this.collectionRestEqualityUtils.isCollectionRestEqualWithoutMetadata(originalCollectionRest, collectionRest)) {
            throw new IllegalArgumentException("The UUID in the Json and the UUID in the url do not match: " + id + ", " + collectionRest.getId());
        }
        this.metadataConverter.setMetadata(context, (DSpaceObject)collection, collectionRest.getMetadata());
        return (CollectionRest)this.converter.toRest((Object)collection, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'DELETE')")
    protected void delete(Context context, UUID id) throws AuthorizeException {
        try {
            Collection collection = (Collection)this.cs.find(context, id);
            if (collection == null) {
                throw new ResourceNotFoundException("core.collection with id: " + id + " not found");
            }
            this.cs.delete(context, (DSpaceObject)collection);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to delete Collection with id = " + id, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete collection because the logo couldn't be deleted", e);
        }
    }

    public BitstreamRest setLogo(Context context, Collection collection, MultipartFile uploadfile) throws IOException, AuthorizeException, SQLException {
        if (collection.getLogo() != null) {
            throw new UnprocessableEntityException("The collection with the given uuid already has a logo: " + collection.getID());
        }
        Bitstream bitstream = this.cs.setLogo(context, collection, uploadfile.getInputStream());
        this.cs.update(context, (DSpaceObject)collection);
        this.bitstreamService.update(context, (DSpaceObject)bitstream);
        return (BitstreamRest)this.converter.toRest((Object)((Bitstream)context.reloadEntity((ReloadableEntity)bitstream)), this.utils.obtainProjection());
    }

    public TemplateItemRest createTemplateItem(Context context, Collection collection, TemplateItemRest inputItemRest) throws SQLException, AuthorizeException {
        if (collection.getTemplateItem() != null) {
            throw new UnprocessableEntityException("Collection with ID " + collection.getID() + " already contains a template item");
        }
        this.cs.createTemplateItem(context, collection);
        Item item = collection.getTemplateItem();
        this.metadataConverter.setMetadata(context, (DSpaceObject)item, inputItemRest.getMetadata());
        item.setDiscoverable(false);
        this.cs.update(context, (DSpaceObject)collection);
        this.itemService.update(context, (DSpaceObject)item);
        return (TemplateItemRest)this.converter.toRest((Object)new TemplateItem(item), this.utils.obtainProjection());
    }

    public TemplateItemRest getTemplateItem(Collection collection) throws SQLException {
        Item item = collection.getTemplateItem();
        if (item == null) {
            throw new ResourceNotFoundException("TemplateItem from core.collection with id: " + collection.getID() + " not found");
        }
        try {
            return (TemplateItemRest)this.converter.toRest((Object)new TemplateItem(item), this.utils.obtainProjection());
        }
        catch (IllegalArgumentException e) {
            throw new UnprocessableEntityException("The item with id " + item.getID() + " is not a template item");
        }
    }
}

