/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.model.WorkflowDefinitionRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.content.Collection;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.workflowdefinition")
public class WorkflowDefinitionRestRepository
extends DSpaceRestRepository<WorkflowDefinitionRest, String> {
    @Autowired
    protected XmlWorkflowFactory xmlWorkflowFactory;
    @Autowired
    private CollectionService collectionService;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public WorkflowDefinitionRest findOne(Context context, String workflowName) {
        if (this.xmlWorkflowFactory.workflowByThisNameExists(workflowName)) {
            try {
                return (WorkflowDefinitionRest)this.converter.toRest((Object)this.xmlWorkflowFactory.getWorkflowByName(workflowName), this.utils.obtainProjection());
            }
            catch (WorkflowConfigurationException e) {
                throw new ResourceNotFoundException("No workflow with name " + workflowName + " is configured");
            }
        }
        throw new ResourceNotFoundException("No workflow with name " + workflowName + " is configured");
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<WorkflowDefinitionRest> findAll(Context context, Pageable pageable) {
        List workflows = this.xmlWorkflowFactory.getAllConfiguredWorkflows();
        return this.converter.toRestPage(this.utils.getPage(workflows, pageable), this.utils.obtainProjection());
    }

    @SearchRestMethod(name="findByCollection")
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public WorkflowDefinitionRest findByCollection(@Parameter(value="uuid") UUID collectionId) throws SQLException {
        Context context = this.obtainContext();
        Collection collectionFromUuid = (Collection)this.collectionService.find(context, collectionId);
        if (collectionFromUuid != null) {
            try {
                return (WorkflowDefinitionRest)this.converter.toRest((Object)this.xmlWorkflowFactory.getWorkflow(collectionFromUuid), this.utils.obtainProjection());
            }
            catch (WorkflowConfigurationException e) {
                throw new ResourceNotFoundException("No workflow for this collection fault and no defaultWorkflow found");
            }
        }
        throw new ResourceNotFoundException("Collection with id " + collectionId + " not found");
    }

    public Class<WorkflowDefinitionRest> getDomainClass() {
        return WorkflowDefinitionRest.class;
    }
}

