/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.MoveOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.DSpaceObjectMetadataPatchUtils;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bundle;
import org.dspace.content.service.BundleService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BundleMoveOperation
extends PatchOperation<Bundle> {
    @Autowired
    BundleService bundleService;
    @Autowired
    DSpaceObjectMetadataPatchUtils dspaceObjectMetadataPatchUtils;
    private static final String OPERATION_PATH_BUNDLE_MOVE = "/_links/bitstreams/";

    public Bundle perform(Context context, Bundle bundle, Operation operation) {
        try {
            MoveOperation moveOperation = (MoveOperation)operation;
            int from = Integer.parseInt(this.dspaceObjectMetadataPatchUtils.getIndexFromPath(moveOperation.getFrom()));
            int to = Integer.parseInt(this.dspaceObjectMetadataPatchUtils.getIndexFromPath(moveOperation.getPath()));
            int totalAmount = bundle.getBitstreams().size();
            if (totalAmount < 1) {
                throw new DSpaceBadRequestException(this.createMoveExceptionMessage(bundle, from, to, "No bitstreams found."));
            }
            if (from >= totalAmount) {
                throw new DSpaceBadRequestException(this.createMoveExceptionMessage(bundle, from, to, "\"from\" location out of bounds. Latest available position: " + (totalAmount - 1)));
            }
            if (to >= totalAmount) {
                throw new DSpaceBadRequestException(this.createMoveExceptionMessage(bundle, from, to, "\"to\" location out of bounds. Latest available position: " + (totalAmount - 1)));
            }
            this.bundleService.updateBitstreamOrder(context, bundle, from, to);
        }
        catch (SQLException | AuthorizeException e) {
            throw new DSpaceBadRequestException(e.getMessage(), (Exception)e);
        }
        return bundle;
    }

    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof Bundle && operation.getOp().trim().equalsIgnoreCase("move") && operation.getPath().trim().startsWith(OPERATION_PATH_BUNDLE_MOVE);
    }

    private String createMoveExceptionMessage(Bundle bundle, int from, int to, String message) {
        return "Failed moving bitstreams of bundle with id " + bundle.getID() + " from location " + from + " to " + to + ": " + message;
    }
}

