/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.PaginationException;
import org.dspace.app.rest.exception.RepositoryNotFoundException;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.LinkRest;
import org.dspace.app.rest.model.LinksRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.DSpaceResource;
import org.dspace.app.rest.model.hateoas.EmbeddedPage;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class);
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int EMBED_MAX_LEVELS = 2;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    RequestService requestService;
    @Autowired(required=true)
    private List<DSpaceObjectService<? extends DSpaceObject>> dSpaceObjectServices;
    @Autowired
    private BitstreamFormatService bitstreamFormatService;
    @Autowired
    private ConverterService converter;
    private Map<Method, Optional<LinkRest>> linkAnnotationForMethod = new HashMap();

    public <T> Page<T> getPage(List<T> fullContents, @Nullable Pageable optionalPageable) {
        Pageable pageable = this.getPageable(optionalPageable);
        int total = fullContents.size();
        List<T> pageContent = null;
        if (pageable.getOffset() > (long)total) {
            throw new PaginationException((long)total);
        }
        pageContent = pageable.getOffset() + (long)pageable.getPageSize() > (long)total ? fullContents.subList(Math.toIntExact(pageable.getOffset()), total) : fullContents.subList(Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getOffset()) + pageable.getPageSize());
        return new PageImpl(pageContent, pageable, (long)total);
    }

    public Pageable getPageable(@Nullable Pageable optionalPageable) {
        return optionalPageable != null ? optionalPageable : new PageRequest(0, 20);
    }

    public Link linkToSingleResource(DSpaceResource r, String rel) {
        RestAddressableModel data = r.getContent();
        return this.linkToSingleResource(data, rel);
    }

    public Link linkToSingleResource(RestAddressableModel data, String rel) {
        return ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo((Class)data.getController(), (Object[])new Object[]{data.getCategory(), data.getTypePlural()}).slash((Object)data)).withRel(rel);
    }

    public Link linkToSubResource(RestAddressableModel data, String rel) {
        return this.linkToSubResource(data, rel, rel);
    }

    public Link linkToSubResource(RestAddressableModel data, String rel, String path) {
        return ((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo((Class)data.getController(), (Object[])new Object[]{data.getCategory(), data.getTypePlural()}).slash((Object)data)).slash((Object)path)).withRel(rel);
    }

    public DSpaceRestRepository getResourceRepository(String apiCategory, String modelPlural) {
        String model = Utils.makeSingular((String)modelPlural);
        try {
            return (DSpaceRestRepository)this.applicationContext.getBean(apiCategory + "." + model, DSpaceRestRepository.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new RepositoryNotFoundException(apiCategory, model);
        }
    }

    public String[] getRepositories() {
        return this.applicationContext.getBeanNamesForType(DSpaceRestRepository.class);
    }

    public static String makeSingular(String modelPlural) {
        if (modelPlural.equals("communities")) {
            return "community";
        }
        if (modelPlural.equals("authorities")) {
            return "authority";
        }
        if (modelPlural.equals("resourcepolicies")) {
            return "resourcepolicy";
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)modelPlural, (CharSequence)"processes")) {
            return "process";
        }
        return modelPlural.replaceAll("s$", "");
    }

    public LinkRestRepository getLinkResourceRepository(String apiCategory, String modelPlural, String rel) {
        String model = Utils.makeSingular((String)modelPlural);
        try {
            return (LinkRestRepository)this.applicationContext.getBean(apiCategory + "." + model + "." + rel, LinkRestRepository.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new RepositoryNotFoundException(apiCategory, model);
        }
    }

    public LinkRest getClassLevelLinkRest(String rel, Class<? extends RestAddressableModel> restClass) {
        Optional<LinkRest> optionalLinkRest = this.getLinkRests(restClass).stream().filter(linkRest -> rel.equals(linkRest.name())).findFirst();
        return optionalLinkRest.isPresent() ? optionalLinkRest.get() : null;
    }

    public String getMetadataKey(String schema, String element, String qualifier) {
        return org.dspace.core.Utils.standardize((String)schema, (String)element, (String)qualifier, (String)".");
    }

    public static File getFile(MultipartFile multipartFile, String prefixTempName, String suffixTempName) throws IOException, FileNotFoundException {
        String tempDir = ConfigurationManager.getProperty((String)"upload.temp.dir") != null ? ConfigurationManager.getProperty((String)"upload.temp.dir") : System.getProperty("java.io.tmpdir");
        File uploadDir = new File(tempDir);
        if (!uploadDir.exists() && !uploadDir.mkdir()) {
            uploadDir = null;
        }
        File file = File.createTempFile(prefixTempName + "-" + suffixTempName, ".temp", uploadDir);
        BufferedInputStream io = new BufferedInputStream(multipartFile.getInputStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        org.dspace.core.Utils.bufferedCopy((InputStream)io, (OutputStream)out);
        return file;
    }

    public static String getFileName(MultipartFile multipartFile) throws IOException, FileNotFoundException {
        String originalFilename = multipartFile.getOriginalFilename();
        if (originalFilename != null) {
            String[] parts = originalFilename.split("[\\/]");
            return parts[parts.length - 1];
        }
        return multipartFile.getName();
    }

    public List<BitstreamFormat> constructBitstreamFormatList(HttpServletRequest request, Context context) {
        return this.getStringListFromRequest(request).stream().map(link -> {
            if (link.endsWith("/")) {
                link = link.substring(0, link.length() - 1);
            }
            return link.substring(link.lastIndexOf(47) + 1);
        }).map(id -> {
            try {
                return (BitstreamFormat)this.bitstreamFormatService.find(context, Integer.parseInt(id));
            }
            catch (NumberFormatException | SQLException e) {
                log.error((Object)("Could not find bitstream format for id: " + id), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<DSpaceObject> constructDSpaceObjectList(Context context, List<String> list) {
        LinkedList<DSpaceObject> dSpaceObjects = new LinkedList<DSpaceObject>();
        for (String string : list) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            String uuid = string.substring(string.lastIndexOf(47) + 1);
            try {
                for (DSpaceObjectService dSpaceObjectService : this.dSpaceObjectServices) {
                    DSpaceObject dSpaceObject = dSpaceObjectService.find(context, UUIDUtils.fromString((String)uuid));
                    if (dSpaceObject == null) continue;
                    dSpaceObjects.add(dSpaceObject);
                }
            }
            catch (SQLException e) {
                log.error((Object)("Could not find DSpaceObject for UUID: " + uuid), (Throwable)e);
            }
        }
        return dSpaceObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFromRequest(HttpServletRequest request) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        try (Scanner scanner = new Scanner((InputStream)request.getInputStream());){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!StringUtils.hasText((String)line)) continue;
                list.add(line);
            }
        }
        return list;
    }

    public List<String> getStringListFromRequest(HttpServletRequest request) {
        List list = null;
        try {
            list = this.readFromRequest(request);
        }
        catch (IOException e) {
            log.error((Object)"Something went wrong with reading in the inputstream from the request", (Throwable)e);
        }
        return list;
    }

    public <T extends HALResource> T toResource(RestModel restObject) {
        return (T)this.converter.toResource(restObject);
    }

    public String[] getSortedUnion(String[] ... arrays) {
        TreeSet<String> set = new TreeSet<String>();
        String[][] stringArray = arrays;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] array;
            for (String string : array = stringArray[i]) {
                set.add(string);
            }
        }
        return set.toArray(arrays[0]);
    }

    public Method requireMethod(Class clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        throw new IllegalArgumentException("No such method in " + clazz + ": " + name);
    }

    public Projection obtainProjection() {
        String projectionName = this.requestService.getCurrentRequest().getServletRequest().getParameter("projection");
        return this.converter.getProjection(projectionName);
    }

    public void embedOrLinkClassLevelRels(HALResource<RestAddressableModel> halResource) {
        Projection projection = ((RestAddressableModel)halResource.getContent()).getProjection();
        this.getLinkRests(((RestAddressableModel)halResource.getContent()).getClass()).stream().forEach(linkRest -> {
            Link link = this.linkToSubResource((RestAddressableModel)halResource.getContent(), linkRest.name());
            if (projection.allowEmbedding(halResource, linkRest)) {
                this.embedRelFromRepository(halResource, linkRest.name(), link, linkRest);
                halResource.add(link);
            } else if (projection.allowLinking(halResource, linkRest)) {
                halResource.add(link);
            }
        });
    }

    private List<LinkRest> getLinkRests(Class<? extends RestAddressableModel> restClass) {
        ArrayList<LinkRest> list = new ArrayList<LinkRest>();
        LinksRest linksAnnotation = restClass.getDeclaredAnnotation(LinksRest.class);
        if (linksAnnotation != null) {
            list.addAll(Arrays.asList(linksAnnotation.links()));
        }
        return list;
    }

    void embedRelFromRepository(HALResource<? extends RestAddressableModel> resource, String rel, Link link, LinkRest linkRest) {
        if (((RestAddressableModel)resource.getContent()).getEmbedLevel() == 2) {
            return;
        }
        Projection projection = ((RestAddressableModel)resource.getContent()).getProjection();
        LinkRestRepository linkRepository = this.getLinkResourceRepository(((RestAddressableModel)resource.getContent()).getCategory(), ((RestAddressableModel)resource.getContent()).getType(), rel);
        if (linkRepository.isEmbeddableRelation(resource.getContent(), rel)) {
            Method method = this.requireMethod(linkRepository.getClass(), linkRest.method());
            Object contentId = this.getContentIdForLinkMethod((RestAddressableModel)resource.getContent(), method);
            try {
                Object linkedObject = method.invoke((Object)linkRepository, null, contentId, null, projection);
                resource.embedResource(rel, this.wrapForEmbedding(resource, linkedObject, link));
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void embedMethodLevelRels(HALResource<? extends RestAddressableModel> resource) {
        if (((RestAddressableModel)resource.getContent()).getEmbedLevel() == 2) {
            return;
        }
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(((RestAddressableModel)resource.getContent()).getClass()).getPropertyDescriptors()) {
                Method readMethod = pd.getReadMethod();
                String propertyName = pd.getName();
                if (readMethod == null || "class".equals(propertyName)) continue;
                this.embedMethodLevelRel(resource, readMethod, propertyName);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public LinkRest findLinkAnnotation(Method readMethod) {
        Optional optional = (Optional)this.linkAnnotationForMethod.get(readMethod);
        if (optional == null) {
            LinkRest linkRest = (LinkRest)AnnotationUtils.findAnnotation((Method)readMethod, LinkRest.class);
            optional = linkRest != null ? Optional.of(linkRest) : Optional.empty();
            this.linkAnnotationForMethod.put(readMethod, optional);
        }
        return optional.isPresent() ? (LinkRest)optional.get() : null;
    }

    private void embedMethodLevelRel(HALResource<? extends RestAddressableModel> resource, Method readMethod, String propertyName) {
        String rel = propertyName;
        LinkRest linkRest = this.findLinkAnnotation(readMethod);
        try {
            if (linkRest != null) {
                if (!((RestAddressableModel)resource.getContent()).getProjection().allowEmbedding(resource, linkRest)) {
                    return;
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)linkRest.name())) {
                    rel = linkRest.name();
                }
                Link link = this.linkToSubResource((RestAddressableModel)resource.getContent(), rel);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)linkRest.method())) {
                    Object linkedObject = readMethod.invoke(resource.getContent(), new Object[0]);
                    resource.embedResource(rel, this.wrapForEmbedding(resource, linkedObject, link));
                } else {
                    this.embedRelFromRepository(resource, rel, link, linkRest);
                }
            } else if (RestAddressableModel.class.isAssignableFrom(readMethod.getReturnType())) {
                RestAddressableModel linkedObject = (RestAddressableModel)readMethod.invoke(resource.getContent(), new Object[0]);
                resource.embedResource(rel, linkedObject == null ? null : this.wrapForEmbedding(resource, (Object)linkedObject, this.linkToSubResource((RestAddressableModel)resource.getContent(), rel)));
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object wrapForEmbedding(HALResource<? extends RestAddressableModel> resource, Object linkedObject, Link link) {
        int childEmbedLevel = ((RestAddressableModel)resource.getContent()).getEmbedLevel() + 1;
        if (linkedObject instanceof RestAddressableModel) {
            RestAddressableModel restObject2 = (RestAddressableModel)linkedObject;
            restObject2.setEmbedLevel(childEmbedLevel);
            return this.converter.toResource((RestModel)restObject2);
        }
        if (linkedObject instanceof Page) {
            Page page = (Page)linkedObject;
            return new EmbeddedPage(link.getHref(), page.map(restObject -> {
                restObject.setEmbedLevel(childEmbedLevel);
                return this.converter.toResource((RestModel)restObject);
            }), null, link.getRel());
        }
        if (linkedObject instanceof List) {
            List list = (List)linkedObject;
            if (list.size() > 0) {
                PageImpl page = new PageImpl(list.subList(0, list.size() > 20 ? 20 : list.size()), (Pageable)new PageRequest(0, 20), (long)list.size());
                return new EmbeddedPage(link.getHref(), page.map(restObject -> {
                    restObject.setEmbedLevel(childEmbedLevel);
                    return this.converter.toResource((RestModel)restObject);
                }), list, link.getRel());
            }
            PageImpl page = new PageImpl(list);
            return new EmbeddedPage(link.getHref(), (Page)page, list, link.getRel());
        }
        return linkedObject;
    }

    private Object getContentIdForLinkMethod(RestAddressableModel restObject, Method linkMethod) {
        Serializable contentId = ((BaseObjectRest)restObject).getId();
        Class<?> requiredIdType = linkMethod.getParameterTypes()[1];
        if (!requiredIdType.isAssignableFrom(contentId.getClass())) {
            if (requiredIdType.equals(UUID.class)) {
                contentId = UUID.fromString(contentId.toString());
            } else if (requiredIdType.equals(Integer.class)) {
                contentId = Integer.valueOf(Integer.parseInt(contentId.toString()));
            } else if (requiredIdType.equals(Long.class)) {
                contentId = Long.valueOf(Long.parseLong(contentId.toString()));
            } else {
                throw new IllegalArgumentException("Cannot cast " + restObject.getClass() + " id type " + contentId.getClass() + " to id type required by " + linkMethod.getDeclaringClass() + "#" + linkMethod.getName() + ": " + requiredIdType);
            }
        }
        return contentId;
    }
}

