/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.security.DSpaceAuthentication;
import org.dspace.app.rest.security.EPersonRestAuthenticationProvider;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.RequestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class StatelessAuthenticationFilter
extends BasicAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(StatelessAuthenticationFilter.class);
    private RestAuthenticationService restAuthenticationService;
    private EPersonRestAuthenticationProvider authenticationProvider;
    private RequestService requestService;

    public StatelessAuthenticationFilter(AuthenticationManager authenticationManager, RestAuthenticationService restAuthenticationService, EPersonRestAuthenticationProvider authenticationProvider, RequestService requestService) {
        super(authenticationManager);
        this.requestService = requestService;
        this.restAuthenticationService = restAuthenticationService;
        this.authenticationProvider = authenticationProvider;
    }

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        Authentication authentication = this.getAuthentication(req);
        if (authentication != null) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
            this.restAuthenticationService.invalidateAuthenticationCookie(res);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private Authentication getAuthentication(HttpServletRequest request) {
        if (this.restAuthenticationService.hasAuthenticationData(request)) {
            Context context = ContextUtil.obtainContext((ServletRequest)request);
            EPerson eperson = this.restAuthenticationService.getAuthenticatedEPerson(request, context);
            if (eperson != null) {
                this.requestService.setCurrentUserId(eperson.getID());
                List authorities = this.authenticationProvider.getGrantedAuthorities(context, eperson);
                return new DSpaceAuthentication(eperson.getEmail(), authorities);
            }
            return null;
        }
        return null;
    }
}

