/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security.jwt;

import com.nimbusds.jose.JOSEException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceAuthentication;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.app.rest.security.jwt.JWTTokenHandler;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JWTTokenRestAuthenticationServiceImpl
implements RestAuthenticationService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RestAuthenticationService.class);
    private static final String AUTHORIZATION_COOKIE = "Authorization-cookie";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTHORIZATION_TYPE = "Bearer";
    @Autowired
    private JWTTokenHandler jwtTokenHandler;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private AuthenticationService authenticationService;

    public void afterPropertiesSet() throws Exception {
    }

    public void addAuthenticationDataForUser(HttpServletRequest request, HttpServletResponse response, DSpaceAuthentication authentication, boolean addCookie) throws IOException {
        try {
            Context context = ContextUtil.obtainContext((ServletRequest)request);
            context.setCurrentUser(this.ePersonService.findByEmail(context, authentication.getName()));
            List groups = this.authenticationService.getSpecialGroups(context, request);
            String token = this.jwtTokenHandler.createTokenForEPerson(context, request, authentication.getPreviousLoginDate(), groups);
            this.addTokenToResponse(response, token, Boolean.valueOf(addCookie));
            context.commit();
        }
        catch (JOSEException e) {
            log.error("JOSE Exception", (Throwable)e);
        }
        catch (SQLException e) {
            log.error("SQL error when adding authentication", (Throwable)e);
        }
    }

    public EPerson getAuthenticatedEPerson(HttpServletRequest request, Context context) {
        String token = this.getToken(request);
        try {
            EPerson ePerson = this.jwtTokenHandler.parseEPersonFromToken(token, request, context);
            return ePerson;
        }
        catch (JOSEException e) {
            log.error("Jose error", (Throwable)e);
        }
        catch (ParseException e) {
            log.error("Error parsing EPerson from token", (Throwable)e);
        }
        catch (SQLException e) {
            log.error("SQL error while retrieving EPerson from token", (Throwable)e);
        }
        return null;
    }

    public boolean hasAuthenticationData(HttpServletRequest request) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader(AUTHORIZATION_HEADER)) || StringUtils.isNotBlank((CharSequence)this.getAuthorizationCookie(request));
    }

    public void invalidateAuthenticationData(HttpServletRequest request, HttpServletResponse response, Context context) throws Exception {
        String token = this.getToken(request);
        this.invalidateAuthenticationCookie(response);
        this.jwtTokenHandler.invalidateToken(token, request, context);
    }

    public void invalidateAuthenticationCookie(HttpServletResponse response) {
        Cookie cookie = new Cookie(AUTHORIZATION_COOKIE, "");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public String getWwwAuthenticateHeaderValue(HttpServletRequest request, HttpServletResponse response) {
        Iterator authenticationMethodIterator = this.authenticationService.authenticationMethodIterator();
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        StringBuilder wwwAuthenticate = new StringBuilder();
        while (authenticationMethodIterator.hasNext()) {
            AuthenticationMethod authenticationMethod = (AuthenticationMethod)authenticationMethodIterator.next();
            if (wwwAuthenticate.length() > 0) {
                wwwAuthenticate.append(", ");
            }
            wwwAuthenticate.append(authenticationMethod.getName()).append(" realm=\"DSpace REST API\"");
            String loginPageURL = authenticationMethod.loginPageURL(context, request, response);
            if (!StringUtils.isNotBlank((CharSequence)loginPageURL)) continue;
            wwwAuthenticate.append(", location=\"").append(loginPageURL).append("\"");
        }
        return wwwAuthenticate.toString();
    }

    private void addTokenToResponse(HttpServletResponse response, String token, Boolean addCookie) throws IOException {
        if (addCookie.booleanValue()) {
            Cookie cookie = new Cookie(AUTHORIZATION_COOKIE, token);
            cookie.setHttpOnly(true);
            cookie.setSecure(true);
            response.addCookie(cookie);
        }
        response.setHeader(AUTHORIZATION_HEADER, String.format("%s %s", AUTHORIZATION_TYPE, token));
    }

    private String getToken(HttpServletRequest request) {
        String tokenValue = null;
        String authHeader = request.getHeader(AUTHORIZATION_HEADER);
        String authCookie = this.getAuthorizationCookie(request);
        if (StringUtils.isNotBlank((CharSequence)authHeader)) {
            tokenValue = authHeader.replace(AUTHORIZATION_TYPE, "").trim();
        } else if (StringUtils.isNotBlank((CharSequence)authCookie)) {
            tokenValue = authCookie;
        }
        return tokenValue;
    }

    private String getAuthorizationCookie(HttpServletRequest request) {
        String authCookie = "";
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(AUTHORIZATION_COOKIE) || !StringUtils.isNotEmpty((CharSequence)cookie.getValue())) continue;
                authCookie = cookie.getValue();
            }
        }
        return authCookie;
    }
}

