/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.atteo.evo.inflector.English;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BitstreamFormatRest;
import org.dspace.app.rest.model.CheckSumRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.UploadBitstreamAccessConditionDTO;
import org.dspace.app.rest.model.WorkspaceItemRest;
import org.dspace.app.rest.model.step.UploadBitstreamRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowItemService;
import org.dspace.workflow.WorkflowService;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.init.UncategorizedScriptException;
import org.springframework.stereotype.Component;

@Component
public class SubmissionService {
    private static final Logger log = LogManager.getLogger(SubmissionService.class);
    @Autowired
    protected ConfigurationService configurationService;
    @Autowired
    protected CollectionService collectionService;
    @Autowired
    protected ItemService itemService;
    @Autowired
    protected WorkspaceItemService workspaceItemService;
    @Autowired
    protected WorkflowItemService<XmlWorkflowItem> workflowItemService;
    @Autowired
    protected WorkflowService<XmlWorkflowItem> workflowService;
    @Autowired
    private RequestService requestService;
    @Autowired
    private ConverterService converter;
    @Autowired
    private org.dspace.app.rest.utils.Utils utils;

    public WorkspaceItem createWorkspaceItem(Context context, Request request) throws SQLException, AuthorizeException {
        WorkspaceItem wsi = null;
        Collection collection = null;
        String collectionUUID = request.getHttpServletRequest().getParameter("owningCollection");
        if (StringUtils.isBlank((CharSequence)collectionUUID)) {
            collectionUUID = this.configurationService.getProperty("submission.default.collection");
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)collectionUUID)) {
                collection = (Collection)this.collectionService.find(context, UUID.fromString(collectionUUID));
            } else {
                List findAuthorizedOptimized = this.collectionService.findAuthorizedOptimized(context, 3);
                if (findAuthorizedOptimized != null && findAuthorizedOptimized.size() > 0) {
                    collection = (Collection)findAuthorizedOptimized.get(0);
                } else {
                    throw new RESTAuthorizationException("No collection suitable for submission for the current user");
                }
            }
            if (collection == null) {
                throw new RESTAuthorizationException("collectionUUID=" + collectionUUID + " not found");
            }
            wsi = this.workspaceItemService.create(context, collection, true);
        }
        catch (SQLException e) {
            throw new UncategorizedScriptException(e.getMessage(), (Throwable)e);
        }
        catch (AuthorizeException ae) {
            throw new RESTAuthorizationException(ae);
        }
        return wsi;
    }

    public void saveWorkspaceItem(Context context, WorkspaceItem wsi) {
        try {
            this.workspaceItemService.update(context, (InProgressSubmission)wsi);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public UploadBitstreamRest buildUploadBitstream(ConfigurationService configurationService, Bitstream source) throws SQLException {
        UploadBitstreamRest data = new UploadBitstreamRest();
        for (MetadataValue md : source.getMetadata()) {
            MetadataValueRest dto = new MetadataValueRest();
            dto.setAuthority(md.getAuthority());
            dto.setConfidence(md.getConfidence());
            dto.setLanguage(md.getLanguage());
            dto.setPlace(md.getPlace());
            dto.setValue(md.getValue());
            String[] metadataToCheck = Utils.tokenize((String)md.getMetadataField().toString());
            if (data.getMetadata().containsKey(Utils.standardize((String)metadataToCheck[0], (String)metadataToCheck[1], (String)metadataToCheck[2], (String)"."))) {
                ((List)data.getMetadata().get(Utils.standardize((String)md.getMetadataField().getMetadataSchema().getName(), (String)md.getMetadataField().getElement(), (String)md.getMetadataField().getQualifier(), (String)"."))).add(dto);
                continue;
            }
            ArrayList<Object> listDto = new ArrayList<Object>();
            listDto.add(dto);
            data.getMetadata().put(Utils.standardize((String)md.getMetadataField().getMetadataSchema().getName(), (String)md.getMetadataField().getElement(), (String)md.getMetadataField().getQualifier(), (String)"."), listDto);
        }
        Projection projection = this.utils.obtainProjection();
        HttpServletRequest request = this.requestService.getCurrentRequest().getHttpServletRequest();
        data.setFormat((BitstreamFormatRest)this.converter.toRest((Object)source.getFormat(ContextUtil.obtainContext((ServletRequest)request)), projection));
        for (ResourcePolicy rp : source.getResourcePolicies()) {
            if (!ResourcePolicy.TYPE_CUSTOM.equals(rp.getRpType())) continue;
            UploadBitstreamAccessConditionDTO uploadAccessCondition = this.createAccessConditionFromResourcePolicy(rp);
            data.getAccessConditions().add(uploadAccessCondition);
        }
        data.setUuid(source.getID());
        CheckSumRest checksum = new CheckSumRest();
        checksum.setCheckSumAlgorithm(source.getChecksumAlgorithm());
        checksum.setValue(source.getChecksum());
        data.setCheckSum(checksum);
        data.setSizeBytes(Long.valueOf(source.getSizeBytes()));
        data.setUrl(configurationService.getProperty("dspace.server.url") + "/api/core/" + English.plural((String)"bitstream") + "/" + source.getID() + "/content");
        return data;
    }

    public XmlWorkflowItem createWorkflowItem(Context context, String requestUriListString) throws SQLException, AuthorizeException, WorkflowException {
        XmlWorkflowItem wi = null;
        if (StringUtils.isBlank((CharSequence)requestUriListString)) {
            throw new UnprocessableEntityException("Malformed body..." + requestUriListString);
        }
        String regex = "\\/api\\/submission\\/" + English.plural((String)"workspaceitem") + "\\/";
        String[] split = requestUriListString.split(regex, 2);
        if (split.length != 2) {
            throw new UnprocessableEntityException("Malformed body..." + requestUriListString);
        }
        WorkspaceItem wsi = null;
        int id = 0;
        try {
            id = Integer.parseInt(split[1]);
            wsi = this.workspaceItemService.find(context, id);
        }
        catch (NumberFormatException e) {
            throw new UnprocessableEntityException("The provided workspaceitem URI is not valid");
        }
        if (wsi == null) {
            throw new UnprocessableEntityException("Workspace item is not found");
        }
        WorkspaceItemRest wsiRest = (WorkspaceItemRest)this.converter.toRest((Object)wsi, this.utils.obtainProjection());
        if (!wsiRest.getErrors().isEmpty()) {
            throw new UnprocessableEntityException("Start workflow failed due to validation error on workspaceitem");
        }
        try {
            wi = (XmlWorkflowItem)this.workflowService.start(context, wsi);
        }
        catch (IOException e) {
            throw new RuntimeException("The workflow could not be started for workspaceItem withid:  " + id);
        }
        return wi;
    }

    private UploadBitstreamAccessConditionDTO createAccessConditionFromResourcePolicy(ResourcePolicy rp) {
        UploadBitstreamAccessConditionDTO accessCondition = new UploadBitstreamAccessConditionDTO();
        accessCondition.setId(rp.getID());
        accessCondition.setName(rp.getRpName());
        accessCondition.setDescription(rp.getRpDescription());
        accessCondition.setStartDate(rp.getStartDate());
        accessCondition.setEndDate(rp.getEndDate());
        if (rp.getGroup() != null) {
            accessCondition.setGroupUUID(rp.getGroup().getID());
        }
        if (rp.getEPerson() != null) {
            accessCondition.setEpersonUUID(rp.getEPerson().getID());
        }
        return accessCondition;
    }

    public void saveWorkflowItem(Context context, XmlWorkflowItem source) throws SQLException, AuthorizeException {
        this.workflowItemService.update(context, (InProgressSubmission)source);
    }
}

