/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.rest.exception.MethodNotAllowedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/items/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/mappedCollections"})
public class MappedCollectionRestController {
    private static final Logger log = Logger.getLogger(MappedCollectionRestController.class);
    @Autowired
    private ItemService itemService;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    Utils utils;

    @RequestMapping(method={RequestMethod.POST}, consumes={"text/uri-list"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void createCollectionToItemRelation(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        List listDsoFoundInRequest = this.utils.constructDSpaceObjectList(context, this.utils.getStringListFromRequest(request));
        if (listDsoFoundInRequest.size() < 1) {
            throw new UnprocessableEntityException("Not a valid collection uuid.");
        }
        for (DSpaceObject dso : listDsoFoundInRequest) {
            Item item = (Item)this.itemService.find(context, uuid);
            if (dso != null && dso.getType() == 3 && item != null) {
                this.checkIfItemIsTemplate(item);
                Collection collectionToMapTo = (Collection)dso;
                this.checkIfOwningCollection(item, collectionToMapTo.getID());
                this.collectionService.addItem(context, collectionToMapTo, item);
                this.collectionService.update(context, (DSpaceObject)collectionToMapTo);
                this.itemService.update(context, (DSpaceObject)item);
                continue;
            }
            throw new UnprocessableEntityException("Not a valid collection or item uuid.");
        }
        context.commit();
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{collectionUuid}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCollectionToItemRelation(@PathVariable UUID uuid, @PathVariable UUID collectionUuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        Collection collection = (Collection)this.collectionService.find(context, collectionUuid);
        Item item = (Item)this.itemService.find(context, uuid);
        if (collection != null && item != null) {
            this.checkIfItemIsTemplate(item);
            UUID owningCollectionUuid = item.getOwningCollection().getID();
            this.checkIfOwningCollection(item, collectionUuid);
            if (collection.getID() != owningCollectionUuid && item.getCollections().contains(collection)) {
                this.collectionService.removeItem(context, collection, item);
                this.collectionService.update(context, (DSpaceObject)collection);
                this.itemService.update(context, (DSpaceObject)item);
                context.commit();
            }
        } else {
            throw new UnprocessableEntityException("Not a valid collection or item uuid.");
        }
    }

    private void checkIfItemIsTemplate(Item item) {
        if (item.getTemplateItemOf() != null) {
            throw new MethodNotAllowedException("Given item is a template item.");
        }
    }

    private void checkIfOwningCollection(Item item, UUID collectionID) {
        if (item.getOwningCollection().getID().equals(collectionID)) {
            throw new UnprocessableEntityException("Collection given same as owningCollection of item.");
        }
    }
}

