/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestPermissionEvaluatorPlugin;
import org.springframework.security.core.Authentication;

public abstract class RestObjectPermissionEvaluatorPlugin
implements RestPermissionEvaluatorPlugin {
    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        BaseObjectRest restObject = (BaseObjectRest)targetDomainObject;
        return this.hasPermission(authentication, restObject.getId(), restObject.getType(), permission);
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        if (permission instanceof Patch) {
            return this.hasPatchPermission(authentication, targetId, targetType, (Patch)permission);
        }
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        return this.hasDSpacePermission(authentication, targetId, targetType, restPermission);
    }

    public boolean hasPatchPermission(Authentication authentication, Serializable targetId, String targetType, Patch patch) {
        return this.hasPermission(authentication, targetId, targetType, (Object)"WRITE");
    }

    public abstract boolean hasDSpacePermission(Authentication var1, Serializable var2, String var3, DSpaceRestPermission var4);
}

