/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.TemplateItemRest;
import org.dspace.app.rest.model.hateoas.TemplateItemResource;
import org.dspace.app.rest.model.wrapper.TemplateItem;
import org.dspace.app.rest.repository.ItemTemplateItemOfLinkRepository;
import org.dspace.app.rest.repository.TemplateItemRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/itemtemplates/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"})
public class ItemTemplateRestController {
    @Autowired
    private Utils utils;
    @Autowired
    private ItemService itemService;
    @Autowired
    private TemplateItemRestRepository templateItemRestRepository;
    @Autowired
    private ConverterService converter;
    @Autowired
    private ItemTemplateItemOfLinkRepository itemTemplateItemOfLinkRepository;

    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'READ')")
    @RequestMapping(method={RequestMethod.GET})
    public TemplateItemResource getTemplateItem(HttpServletRequest request, @PathVariable UUID uuid) {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        TemplateItemRest templateItem = this.templateItemRestRepository.findOne(context, uuid);
        if (templateItem == null) {
            throw new ResourceNotFoundException("Item with id: " + uuid + " not found");
        }
        return (TemplateItemResource)((Object)this.converter.toResource(templateItem));
    }

    @PreAuthorize(value="hasPermission(#uuid, 'ITEM', 'WRITE')")
    @RequestMapping(method={RequestMethod.PATCH})
    public ResponseEntity<RepresentationModel<?>> patch(HttpServletRequest request, @PathVariable UUID uuid, @RequestBody(required=true) JsonNode jsonNode) throws SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        TemplateItem templateItem = this.getTemplateItem(context, uuid);
        TemplateItemRest templateItemRest = this.templateItemRestRepository.patchTemplateItem(templateItem, jsonNode);
        context.commit();
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.OK, (HttpHeaders)new HttpHeaders(), this.converter.toResource(templateItemRest));
    }

    @PreAuthorize(value="hasPermission(#uuid, 'ITEM', 'DELETE')")
    @RequestMapping(method={RequestMethod.DELETE})
    public ResponseEntity<RepresentationModel<?>> deleteTemplateItem(HttpServletRequest request, @PathVariable UUID uuid) throws SQLException, AuthorizeException, IOException {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        TemplateItem item = this.getTemplateItem(context, uuid);
        this.templateItemRestRepository.removeTemplateItem(context, item);
        context.commit();
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }

    private TemplateItem getTemplateItem(Context context, UUID uuid) throws SQLException {
        Item item = (Item)this.itemService.find(context, uuid);
        if (item == null) {
            throw new ResourceNotFoundException("The given uuid did not resolve to an item on the server: " + uuid);
        }
        if (item.getTemplateItemOf() == null) {
            throw new DSpaceBadRequestException("This given uuid does not resolve to a TemplateItem");
        }
        try {
            return new TemplateItem(item);
        }
        catch (IllegalArgumentException e) {
            throw new UnprocessableEntityException("The item with id " + uuid + " is not a template item");
        }
    }
}

