/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.RelationshipTypeRest;
import org.dspace.app.rest.model.hateoas.RelationshipTypeResource;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.content.EntityType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedModel;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/entitytypes/{id}/relationshiptypes"})
public class RelationshipTypeRestController {
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private ConverterService converter;
    @Autowired
    private Utils utils;
    @Autowired
    private HalLinkService halLinkService;

    @RequestMapping(method={RequestMethod.GET})
    public PagedModel<RelationshipTypeResource> retrieve(@PathVariable Integer id, HttpServletResponse response, HttpServletRequest request, Pageable pageable, PagedResourcesAssembler assembler) throws SQLException {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        EntityType entityType = (EntityType)this.entityTypeService.find(context, id.intValue());
        List list = this.relationshipTypeService.findByEntityType(context, entityType, Integer.valueOf(-1), Integer.valueOf(-1));
        Page relationshipTypeRestPage = this.converter.toRestPage(list, pageable, this.utils.obtainProjection());
        Page relationshipTypeResources = relationshipTypeRestPage.map(relationshipTypeRest -> new RelationshipTypeResource((RelationshipTypeRest)relationshipTypeRest, this.utils));
        relationshipTypeResources.forEach(this.halLinkService::addLinks);
        PagedModel result = assembler.toModel(relationshipTypeResources);
        return result;
    }
}

