/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.SubmissionSectionRest;
import org.dspace.app.rest.model.SubmissionVisibilityRest;
import org.dspace.app.rest.model.VisibilityEnum;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.springframework.stereotype.Component;

@Component
public class SubmissionSectionConverter
implements DSpaceConverter<SubmissionStepConfig, SubmissionSectionRest> {
    private static final Logger log = LogManager.getLogger(SubmissionSectionConverter.class);
    private SubmissionConfigReader submissionConfigReader;

    @Override
    public SubmissionSectionRest convert(SubmissionStepConfig step, Projection projection) {
        SubmissionSectionRest sp = new SubmissionSectionRest();
        sp.setProjection(projection);
        sp.setMandatory(step.isMandatory());
        sp.setHeader(step.getHeading());
        sp.setSectionType(step.getType());
        sp.setId(step.getId());
        sp.setVisibility(new SubmissionVisibilityRest(VisibilityEnum.fromString(step.getVisibility()), VisibilityEnum.fromString(step.getVisibilityOutside())));
        return sp;
    }

    public SubmissionStepConfig toModel(SubmissionSectionRest obj) {
        SubmissionStepConfig step;
        try {
            step = this.getSubmissionConfigReader().getStepConfig((String)obj.getId());
        }
        catch (SubmissionConfigReaderException e) {
            throw new RuntimeException(e);
        }
        return step;
    }

    @Override
    public Class<SubmissionStepConfig> getModelClass() {
        return SubmissionStepConfig.class;
    }

    public SubmissionConfigReader getSubmissionConfigReader() throws SubmissionConfigReaderException {
        if (this.submissionConfigReader == null) {
            this.submissionConfigReader = new SubmissionConfigReader();
        }
        return this.submissionConfigReader;
    }
}

