/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link;

import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletRequest;
import org.dspace.app.rest.CollectionGroupRestController;
import org.dspace.app.rest.link.HalLinkFactory;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.hateoas.CollectionResource;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.Collection;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.dspace.xmlworkflow.WorkflowUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.stereotype.Component;

@Component
public class CollectionResourceWorkflowGroupHalLinkFactory
extends HalLinkFactory<CollectionResource, CollectionGroupRestController> {
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private RequestService requestService;

    @Override
    protected void addLinks(CollectionResource halResource, Pageable pageable, LinkedList<Link> list) throws Exception {
        Context context = ContextUtil.obtainContext((ServletRequest)this.requestService.getCurrentRequest().getHttpServletRequest());
        Collection collection = (Collection)this.collectionService.find(context, UUID.fromString(((CollectionRest)halResource.getContent()).getId()));
        Map roles = WorkflowUtils.getCollectionRoles((Collection)collection);
        UUID resourceUuid = UUID.fromString(((CollectionRest)halResource.getContent()).getUuid());
        for (Map.Entry entry : roles.entrySet()) {
            list.add(this.buildLink("workflowGroups/" + (String)entry.getKey(), ((CollectionGroupRestController)this.getMethodOn(new Object[0])).getWorkflowGroupForRole(resourceUuid, null, null, (String)entry.getKey())));
        }
    }

    @Override
    protected Class<CollectionGroupRestController> getControllerClass() {
        return CollectionGroupRestController.class;
    }

    @Override
    protected Class<CollectionResource> getResourceClass() {
        return CollectionResource.class;
    }
}

