/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.projection;

import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.exception.MissingParameterException;
import org.dspace.app.rest.model.LinkRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.projection.AbstractProjection;
import org.dspace.services.RequestService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;

public class SpecificLevelProjection
extends AbstractProjection {
    @Autowired
    private RequestService requestService;
    public static final String NAME = "level";
    private int maxEmbed = DSpaceServicesFactory.getInstance().getConfigurationService().getIntProperty("rest.projections.full.max", 2);

    public int getMaxEmbed() {
        return this.maxEmbed;
    }

    public void setMaxEmbed(int maxEmbed) {
        this.maxEmbed = maxEmbed;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean allowEmbedding(HALResource<? extends RestAddressableModel> halResource, LinkRest linkRest, Link ... oldLinks) {
        String embedLevelDepthString = this.requestService.getCurrentRequest().getHttpServletRequest().getParameter("embedLevelDepth");
        if (StringUtils.isBlank((CharSequence)embedLevelDepthString)) {
            throw new MissingParameterException("The embedLevelDepth parameter needs to be specified for this Projection");
        }
        Integer embedLevelDepth = Integer.parseInt(embedLevelDepthString);
        if (embedLevelDepth > this.maxEmbed) {
            throw new IllegalArgumentException("The embedLevelDepth may not exceed the configured max: " + this.maxEmbed);
        }
        return ((RestAddressableModel)halResource.getContent()).getEmbedLevel() < embedLevelDepth;
    }

    @Override
    public boolean allowLinking(HALResource halResource, LinkRest linkRest) {
        return true;
    }
}

