/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.authorization.AuthorizationRestUtil;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="authz.authorization.eperson")
public class AuthorizationEpersonLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private AuthorizationRestUtil authorizationRestUtil;

    @PreAuthorize(value="hasPermission(#authzId, 'AUTHORIZATION', 'READ')")
    public EPersonRest getEperson(@Nullable HttpServletRequest request, String authzId, @Nullable Pageable optionalPageable, Projection projection) {
        EPerson eperson;
        Context context = this.obtainContext();
        try {
            eperson = this.authorizationRestUtil.getEperson(context, authzId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (eperson == null) {
            return null;
        }
        return (EPersonRest)this.converter.toRest(eperson, projection);
    }
}

