/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.RemoveOperation;
import org.dspace.app.rest.model.step.DataDescribe;
import org.dspace.app.rest.submit.AbstractRestProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.factory.PatchOperationFactory;
import org.dspace.app.rest.submit.factory.impl.PatchOperation;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.services.model.Request;

public class DescribeStep
extends org.dspace.submit.step.DescribeStep
implements AbstractRestProcessingStep {
    private static final Logger log = LogManager.getLogger(DescribeStep.class);
    private DCInputsReader inputReader = new DCInputsReader();

    public DataDescribe getData(SubmissionService submissionService, InProgressSubmission obj, SubmissionStepConfig config) {
        DataDescribe data = new DataDescribe();
        try {
            DCInputSet inputConfig = this.inputReader.getInputsByFormName(config.getId());
            this.readField(obj, config, data, inputConfig);
        }
        catch (DCInputsReaderException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return data;
    }

    private void readField(InProgressSubmission obj, SubmissionStepConfig config, DataDescribe data, DCInputSet inputConfig) throws DCInputsReaderException {
        DCInput[][] dCInputArray = inputConfig.getFields();
        int n = dCInputArray.length;
        for (int i = 0; i < n; ++i) {
            DCInput[] row;
            for (DCInput input : row = dCInputArray[i]) {
                ArrayList<Object> fieldsName = new ArrayList<Object>();
                if (input.isQualdropValue()) {
                    for (Object e : input.getPairs()) {
                        fieldsName.add(input.getFieldName() + "." + (String)e);
                    }
                } else {
                    fieldsName.add(input.getFieldName());
                }
                for (String string : fieldsName) {
                    List mdv = this.itemService.getMetadataByMetadataString((DSpaceObject)obj.getItem(), string);
                    for (MetadataValue md : mdv) {
                        MetadataValueRest dto = new MetadataValueRest();
                        dto.setAuthority(md.getAuthority());
                        dto.setConfidence(md.getConfidence());
                        dto.setLanguage(md.getLanguage());
                        dto.setPlace(md.getPlace());
                        dto.setValue(md.getValue());
                        String[] metadataToCheck = Utils.tokenize((String)md.getMetadataField().toString());
                        if (data.getMetadata().containsKey(Utils.standardize((String)metadataToCheck[0], (String)metadataToCheck[1], (String)metadataToCheck[2], (String)"."))) {
                            data.getMetadata().get(Utils.standardize((String)md.getMetadataField().getMetadataSchema().getName(), (String)md.getMetadataField().getElement(), (String)md.getMetadataField().getQualifier(), (String)".")).add(dto);
                            continue;
                        }
                        ArrayList<MetadataValueRest> listDto = new ArrayList<MetadataValueRest>();
                        listDto.add(dto);
                        data.getMetadata().put(Utils.standardize((String)md.getMetadataField().getMetadataSchema().getName(), (String)md.getMetadataField().getElement(), (String)md.getMetadataField().getQualifier(), (String)"."), listDto);
                    }
                }
            }
        }
    }

    @Override
    public void doPatchProcessing(Context context, Request currentRequest, InProgressSubmission source, Operation op, SubmissionStepConfig stepConf) throws Exception {
        String[] pathParts = op.getPath().substring(1).split("/");
        DCInputSet inputConfig = this.inputReader.getInputsByFormName(stepConf.getId());
        if ("remove".equals(op.getOp()) && pathParts.length < 3) {
            String[] path = op.getPath().substring(1).split("/", 3);
            String configId = path[1];
            List<String> fieldsName = this.getInputFieldsName(inputConfig, configId);
            for (String fieldName : fieldsName) {
                String fieldPath = op.getPath() + "/" + fieldName;
                RemoveOperation fieldRemoveOp = new RemoveOperation(fieldPath);
                PatchOperation patchOperation = new PatchOperationFactory().instanceOf("itemmetadata", fieldRemoveOp.getOp());
                patchOperation.perform(context, currentRequest, source, fieldRemoveOp);
            }
        } else {
            PatchOperation patchOperation = new PatchOperationFactory().instanceOf("itemmetadata", op.getOp());
            String[] split = patchOperation.getAbsolutePath(op.getPath()).split("/");
            if (inputConfig.isFieldPresent(split[0])) {
                patchOperation.perform(context, currentRequest, source, op);
            } else {
                throw new UnprocessableEntityException("The field " + split[0] + " is not present in section " + inputConfig.getFormName());
            }
        }
    }

    private List<String> getInputFieldsName(DCInputSet inputConfig, String configId) throws DCInputsReaderException {
        ArrayList<String> fieldsName = new ArrayList<String>();
        DCInput[][] dCInputArray = inputConfig.getFields();
        int n = dCInputArray.length;
        for (int i = 0; i < n; ++i) {
            DCInput[] row;
            for (DCInput input : row = dCInputArray[i]) {
                if (input.isQualdropValue()) {
                    for (Object qualifier : input.getPairs()) {
                        fieldsName.add(input.getFieldName() + "." + (String)qualifier);
                    }
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)input.getInputType(), (CharSequence)"group") || StringUtils.equalsIgnoreCase((CharSequence)input.getInputType(), (CharSequence)"inline-group")) {
                    log.info("Called child form:" + configId + "-" + Utils.standardize((String)input.getSchema(), (String)input.getElement(), (String)input.getQualifier(), (String)"-"));
                    DCInputSet inputConfigChild = this.inputReader.getInputsByFormName(configId + "-" + Utils.standardize((String)input.getSchema(), (String)input.getElement(), (String)input.getQualifier(), (String)"-"));
                    fieldsName.addAll(this.getInputFieldsName(inputConfigChild, configId));
                    continue;
                }
                fieldsName.add(input.getFieldName());
            }
        }
        return fieldsName;
    }
}

