/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.AuthorityEntryRest;
import org.dspace.app.rest.model.AuthorityRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthorityUtils {
    public static final String PRESENTATION_TYPE_LOOKUP = "lookup";
    public static final String PRESENTATION_TYPE_SUGGEST = "suggest";
    public static final String RESERVED_KEYMAP_PARENT = "parent";
    @Autowired
    private ChoiceAuthorityService cas;
    @Autowired
    private ConverterService converter;

    public boolean isChoice(String schema, String element, String qualifier) {
        return this.cas.isChoicesConfigured(Utils.standardize((String)schema, (String)element, (String)qualifier, (String)"_"));
    }

    public String getAuthorityName(String schema, String element, String qualifier) {
        return this.cas.getChoiceAuthorityName(schema, element, qualifier);
    }

    public boolean isClosed(String schema, String element, String qualifier) {
        return this.cas.isClosed(Utils.standardize((String)schema, (String)element, (String)qualifier, (String)"_"));
    }

    public String getPresentation(String schema, String element, String qualifier) {
        return this.cas.getPresentation(Utils.standardize((String)schema, (String)element, (String)qualifier, (String)"_"));
    }

    public AuthorityEntryRest convertEntry(Choice choice, String authorityName, Projection projection) {
        AuthorityEntryRest entry = (AuthorityEntryRest)this.converter.toRest(choice, projection);
        entry.setAuthorityName(authorityName);
        return entry;
    }

    public AuthorityRest convertAuthority(ChoiceAuthority source, String authorityName, Projection projection) {
        AuthorityRest result = (AuthorityRest)this.converter.toRest(source, projection);
        result.setName(authorityName);
        return result;
    }
}

