/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartFileSender {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String METHOD_HEAD = "HEAD";
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private static final String CONTENT_TYPE_MULTITYPE_WITH_BOUNDARY = "multipart/byteranges; boundary=MULTIPART_BYTERANGES";
    public static final String CONTENT_DISPOSITION_INLINE = "inline";
    public static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String ETAG = "ETag";
    private static final String IF_MATCH = "If-Match";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String RANGE = "Range";
    private static final String CONTENT_RANGE = "Content-Range";
    private static final String IF_RANGE = "If-Range";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT_RANGES = "Accept-Ranges";
    private static final String BYTES = "bytes";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String EXPIRES = "Expires";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String IMAGE = "image";
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String BYTES_RANGE_FORMAT = "bytes %d-%d/%d";
    private static final String CONTENT_DISPOSITION_FORMAT = "%s;filename=\"%s\"";
    private static final String BYTES_DINVALID_BYTE_RANGE_FORMAT = "bytes */%d";
    private static final String CACHE_CONTROL = "Cache-Control";
    private int bufferSize = 1000000;
    private static final long DEFAULT_EXPIRE_TIME = 3600000L;
    private static final String CACHE_CONTROL_SETTING = "private,no-cache";
    private BufferedInputStream inputStream;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String contentType;
    private String disposition;
    private long lastModified;
    private long length;
    private String fileName;
    private String checksum;

    public MultipartFileSender(InputStream inputStream) {
        this.inputStream = new BufferedInputStream(inputStream);
    }

    public static MultipartFileSender fromInputStream(InputStream inputStream) {
        return new MultipartFileSender(inputStream);
    }

    public MultipartFileSender with(HttpServletRequest httpRequest) {
        this.request = httpRequest;
        return this;
    }

    public MultipartFileSender with(HttpServletResponse httpResponse) {
        this.response = httpResponse;
        return this;
    }

    public MultipartFileSender withLength(long length) {
        this.length = length;
        return this;
    }

    public MultipartFileSender withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public MultipartFileSender withChecksum(String checksum) {
        this.checksum = checksum;
        return this;
    }

    public MultipartFileSender withMimetype(String mimetype) {
        this.contentType = mimetype;
        return this;
    }

    public MultipartFileSender withLastModified(long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public MultipartFileSender withBufferSize(int bufferSize) {
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
        return this;
    }

    public MultipartFileSender withDisposition(String contentDisposition) {
        this.disposition = contentDisposition;
        return this;
    }

    public void serveResource() throws IOException {
        Range full = this.getFullRange();
        List<Range> ranges = this.getRanges(full);
        if (ranges == null) {
            return;
        }
        this.log.debug("Content-Type : {}", (Object)this.contentType);
        this.response.reset();
        this.response.setBufferSize(this.bufferSize);
        this.response.setHeader(CONTENT_TYPE, this.contentType);
        this.response.setHeader(ACCEPT_RANGES, BYTES);
        this.response.setHeader(ETAG, this.checksum);
        this.response.setDateHeader(LAST_MODIFIED, this.lastModified);
        this.response.setDateHeader(EXPIRES, System.currentTimeMillis() + 3600000L);
        this.response.setHeader(CACHE_CONTROL, CACHE_CONTROL_SETTING);
        if (MultipartFileSender.isNullOrEmpty(this.disposition)) {
            if (this.contentType == null) {
                this.contentType = APPLICATION_OCTET_STREAM;
            } else if (!this.contentType.startsWith(IMAGE)) {
                String accept = this.request.getHeader(ACCEPT);
                this.disposition = accept != null && MultipartFileSender.accepts(accept, this.contentType) ? CONTENT_DISPOSITION_INLINE : CONTENT_DISPOSITION_ATTACHMENT;
            }
        }
        this.response.setHeader(CONTENT_DISPOSITION, String.format(CONTENT_DISPOSITION_FORMAT, this.disposition, this.fileName));
        this.log.debug("Content-Disposition : {}", (Object)this.disposition);
        if (METHOD_HEAD.equals(this.request.getMethod())) {
            this.log.debug("HEAD request - skipping content");
            return;
        }
        try (ServletOutputStream output = this.response.getOutputStream();){
            if (this.hasNoRanges(full, ranges)) {
                this.log.debug("Return full file");
                this.response.setContentType(this.contentType);
                this.response.setHeader(CONTENT_LENGTH, String.valueOf(this.length));
                Range.copy(this.inputStream, (OutputStream)output, this.length, 0L, this.length, this.bufferSize);
            } else if (ranges.size() == 1) {
                Range r = ranges.get(0);
                this.log.debug("Return 1 part of file : from ({}) to ({})", (Object)r.start, (Object)r.end);
                this.response.setContentType(this.contentType);
                this.response.setHeader(CONTENT_RANGE, String.format(BYTES_RANGE_FORMAT, r.start, r.end, r.total));
                this.response.setHeader(CONTENT_LENGTH, String.valueOf(r.length));
                this.response.setStatus(206);
                Range.copy(this.inputStream, (OutputStream)output, this.length, r.start, r.length, this.bufferSize);
            } else {
                this.response.setContentType(CONTENT_TYPE_MULTITYPE_WITH_BOUNDARY);
                this.response.setStatus(206);
                ServletOutputStream sos = output;
                for (Range r : ranges) {
                    this.log.debug("Return multi part of file : from ({}) to ({})", (Object)r.start, (Object)r.end);
                    sos.println("--MULTIPART_BYTERANGES");
                    sos.println("Content-Type: " + this.contentType);
                    sos.println("Content-Range: " + String.format(BYTES_RANGE_FORMAT, r.start, r.end, r.total));
                    this.inputStream.mark(0);
                    Range.copy(this.inputStream, (OutputStream)output, this.length, r.start, r.length, this.bufferSize);
                    this.inputStream.reset();
                    sos.println();
                }
                sos.println("--MULTIPART_BYTERANGES--");
            }
        }
    }

    public boolean isValid() throws IOException {
        if (this.response == null || this.request == null) {
            return false;
        }
        if (this.inputStream == null) {
            this.log.error("Input stream has no content");
            this.response.sendError(404);
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.fileName)) {
            this.response.sendError(500);
            return false;
        }
        String ifNoneMatch = this.request.getHeader(IF_NONE_MATCH);
        if (Objects.nonNull(ifNoneMatch) && MultipartFileSender.matches(ifNoneMatch, this.checksum)) {
            this.log.debug("If-None-Match header should contain \"*\" or ETag. If so, then return 304.");
            this.response.setHeader(ETAG, this.checksum);
            this.response.sendError(304);
            return false;
        }
        long ifModifiedSince = this.request.getDateHeader(IF_MODIFIED_SINCE);
        if (Objects.isNull(ifNoneMatch) && ifModifiedSince != -1L && ifModifiedSince + 1000L > this.lastModified) {
            this.log.debug("If-Modified-Since header should be greater than LastModified. If so, then return 304.");
            this.response.setHeader(ETAG, this.checksum);
            this.response.sendError(304);
            return false;
        }
        String ifMatch = this.request.getHeader(IF_MATCH);
        if (Objects.nonNull(ifMatch) && !MultipartFileSender.matches(ifMatch, this.checksum)) {
            this.log.error("If-Match header should contain \"*\" or ETag. If not, then return 412.");
            this.response.sendError(416);
            return false;
        }
        long ifUnmodifiedSince = this.request.getDateHeader(IF_UNMODIFIED_SINCE);
        if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= this.lastModified) {
            this.log.error("If-Unmodified-Since header should be greater than LastModified. If not, then return 412.");
            this.response.sendError(412);
            return false;
        }
        return true;
    }

    public boolean isNoRangeRequest() throws IOException {
        List<Range> ranges;
        Range full = this.getFullRange();
        return this.hasNoRanges(full, ranges = this.getRanges(full));
    }

    private boolean hasNoRanges(Range full, List<Range> ranges) {
        return ranges != null && (ranges.isEmpty() || ranges.get(0) == full);
    }

    private Range getFullRange() {
        return new Range(0L, this.length - 1L, this.length);
    }

    private List<Range> getRanges(Range fullRange) throws IOException {
        ArrayList<Range> ranges = new ArrayList<Range>();
        String range = this.request.getHeader(RANGE);
        if (Objects.nonNull(range)) {
            block12: {
                if (!range.matches("^bytes=\\d*-\\d*(,\\d*-\\d*)*$")) {
                    this.log.error("Range header should match format \"bytes=n-n,n-n,n-n...\". If not, then return 416.");
                    this.response.setHeader(CONTENT_RANGE, String.format(BYTES_DINVALID_BYTE_RANGE_FORMAT, this.length));
                    this.response.sendError(416);
                    return null;
                }
                String ifRange = this.request.getHeader(IF_RANGE);
                if (Objects.nonNull(ifRange) && !ifRange.equals(this.fileName)) {
                    try {
                        long ifRangeTime = this.request.getDateHeader(IF_RANGE);
                        if (ifRangeTime == -1L || ifRangeTime + 1000L <= this.lastModified) {
                            ranges.add(fullRange);
                        }
                    }
                    catch (IllegalArgumentException ignore) {
                        if (MultipartFileSender.matches(ifRange, this.checksum)) break block12;
                        ranges.add(fullRange);
                    }
                }
            }
            if (ranges.isEmpty()) {
                this.log.debug("If any valid If-Range header, then process each part of byte range.");
                for (String part : range.substring(6).split(",")) {
                    long start = Range.sublong(part, 0, part.indexOf("-"));
                    long end = Range.sublong(part, part.indexOf("-") + 1, part.length());
                    if (start == -1L) {
                        start = this.length - end;
                        end = this.length - 1L;
                    } else if (end == -1L || end > this.length - 1L) {
                        end = this.length - 1L;
                    }
                    if (start > end) {
                        this.log.warn("Check if Range is syntactically valid. If not, then return 416.");
                        this.response.setHeader(CONTENT_RANGE, String.format(BYTES_DINVALID_BYTE_RANGE_FORMAT, this.length));
                        this.response.sendError(416);
                        return null;
                    }
                    ranges.add(new Range(start, end, this.length));
                }
            }
        }
        return ranges;
    }

    private static boolean isNullOrEmpty(String disposition) {
        return StringUtils.isBlank((CharSequence)disposition);
    }

    private static boolean accepts(String acceptHeader, String toAccept) {
        Object[] acceptValues = acceptHeader.split("\\s*(,|;)\\s*");
        Arrays.sort(acceptValues);
        return Arrays.binarySearch(acceptValues, toAccept) > -1 || Arrays.binarySearch(acceptValues, toAccept.replaceAll("/.*$", "/*")) > -1 || Arrays.binarySearch(acceptValues, "*/*") > -1;
    }

    private static boolean matches(String matchHeader, String toMatch) {
        Object[] matchValues = matchHeader.split("\\s*,\\s*");
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }

    private static class Range {
        long start;
        long end;
        long length;
        long total;

        public Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = this.end - this.start + 1L;
            this.total = total;
        }

        private static List<Range> relativize(List<Range> ranges) {
            ArrayList<Range> builder = new ArrayList<Range>(ranges.size());
            Range prevRange = null;
            for (Range r : ranges) {
                Range newRange = Objects.isNull(prevRange) ? r : new Range(r.start - prevRange.end - 1L, r.end - prevRange.end - 1L, r.total);
                builder.add(newRange);
                prevRange = r;
            }
            return builder;
        }

        public static long sublong(String value, int beginIndex, int endIndex) {
            String substring = value.substring(beginIndex, endIndex);
            return substring.length() > 0 ? Long.parseLong(substring) : -1L;
        }

        private static void copy(InputStream input, OutputStream output, long inputSize, long start, long length, int bufferSize) throws IOException {
            byte[] buffer = new byte[bufferSize];
            if (inputSize == length) {
                int read;
                while ((read = input.read(buffer)) > 0) {
                    output.write(buffer, 0, read);
                    output.flush();
                }
            } else {
                int read;
                input.skip(start);
                long toRead = length;
                while ((read = input.read(buffer)) > 0) {
                    if ((toRead -= (long)read) > 0L) {
                        output.write(buffer, 0, read);
                        output.flush();
                        continue;
                    }
                    output.write(buffer, 0, (int)toRead + read);
                    output.flush();
                    break;
                }
            }
        }
    }
}

