/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.FacetConfigurationRest;
import org.dspace.app.rest.model.FacetResultsRest;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.SearchConfigurationRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.dspace.app.rest.model.SearchSupportRest;
import org.dspace.app.rest.model.hateoas.FacetConfigurationResource;
import org.dspace.app.rest.model.hateoas.FacetResultsResource;
import org.dspace.app.rest.model.hateoas.FacetsResource;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.model.hateoas.SearchConfigurationResource;
import org.dspace.app.rest.model.hateoas.SearchResultsResource;
import org.dspace.app.rest.model.hateoas.SearchSupportResource;
import org.dspace.app.rest.parameter.SearchFilter;
import org.dspace.app.rest.repository.DiscoveryRestRepository;
import org.dspace.app.rest.utils.Utils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/discover"})
public class DiscoveryRestController
implements InitializingBean {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    protected Utils utils;
    @Autowired
    private DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    private DiscoveryRestRepository discoveryRestRepository;
    @Autowired
    private HalLinkService halLinkService;
    @Autowired
    private ConverterService converter;

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register((Object)this, Arrays.asList(new Link("/api/discover", "discover")));
    }

    @RequestMapping(method={RequestMethod.GET})
    public SearchSupportResource getSearchSupport(@RequestParam(name="scope", required=false) String dsoScope, @RequestParam(name="configuration", required=false) String configuration) throws Exception {
        SearchSupportRest searchSupportRest = this.discoveryRestRepository.getSearchSupport();
        SearchSupportResource searchSupportResource = (SearchSupportResource)this.converter.toResource((RestModel)searchSupportRest);
        return searchSupportResource;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/search"})
    public SearchConfigurationResource getSearchConfiguration(@RequestParam(name="scope", required=false) String dsoScope, @RequestParam(name="configuration", required=false) String configuration) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Retrieving search configuration for scope " + StringUtils.trimToEmpty((String)dsoScope) + " and configuration name " + StringUtils.trimToEmpty((String)configuration));
        }
        SearchConfigurationRest searchConfigurationRest = this.discoveryRestRepository.getSearchConfiguration(dsoScope, configuration);
        SearchConfigurationResource searchConfigurationResource = (SearchConfigurationResource)this.converter.toResource((RestModel)searchConfigurationRest);
        return searchConfigurationResource;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/search/facets"})
    public FacetsResource getFacets(@RequestParam(name="query", required=false) String query, @RequestParam(name="dsoType", required=false) String dsoType, @RequestParam(name="scope", required=false) String dsoScope, @RequestParam(name="configuration", required=false) String configuration, List<SearchFilter> searchFilters, Pageable page) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Searching with scope: " + StringUtils.trimToEmpty((String)dsoScope) + ", configuration name: " + StringUtils.trimToEmpty((String)configuration) + ", dsoType: " + StringUtils.trimToEmpty((String)dsoType) + ", query: " + StringUtils.trimToEmpty((String)query) + ", filters: " + Objects.toString(searchFilters));
        }
        SearchResultsRest searchResultsRest = this.discoveryRestRepository.getAllFacets(query, dsoType, dsoScope, configuration, searchFilters);
        FacetsResource facetsResource = new FacetsResource(searchResultsRest, page);
        this.halLinkService.addLinks((HALResource)facetsResource, page);
        return facetsResource;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/search/objects"})
    public SearchResultsResource getSearchObjects(@RequestParam(name="query", required=false) String query, @RequestParam(name="dsoType", required=false) String dsoType, @RequestParam(name="scope", required=false) String dsoScope, @RequestParam(name="configuration", required=false) String configuration, List<SearchFilter> searchFilters, Pageable page) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Searching with scope: " + StringUtils.trimToEmpty((String)dsoScope) + ", configuration name: " + StringUtils.trimToEmpty((String)configuration) + ", dsoType: " + StringUtils.trimToEmpty((String)dsoType) + ", query: " + StringUtils.trimToEmpty((String)query) + ", filters: " + Objects.toString(searchFilters) + ", page: " + Objects.toString(page));
        }
        SearchResultsRest searchResultsRest = this.discoveryRestRepository.getSearchObjects(query, dsoType, dsoScope, configuration, searchFilters, page, this.utils.obtainProjection());
        SearchResultsResource searchResultsResource = new SearchResultsResource(searchResultsRest, this.utils, page);
        this.halLinkService.addLinks((HALResource)searchResultsResource, page);
        return searchResultsResource;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/facets"})
    public FacetConfigurationResource getFacetsConfiguration(@RequestParam(name="scope", required=false) String dsoScope, @RequestParam(name="configuration", required=false) String configuration, Pageable pageable) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Retrieving facet configuration for scope " + StringUtils.trimToEmpty((String)dsoScope) + " and configuration name " + StringUtils.trimToEmpty((String)configuration));
        }
        FacetConfigurationRest facetConfigurationRest = this.discoveryRestRepository.getFacetsConfiguration(dsoScope, configuration);
        FacetConfigurationResource facetConfigurationResource = (FacetConfigurationResource)this.converter.toResource((RestModel)facetConfigurationRest);
        this.halLinkService.addLinks((HALResource)facetConfigurationResource, pageable);
        return facetConfigurationResource;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/facets/{name}"})
    public RepresentationModel getFacetValues(@PathVariable(value="name") String facetName, @RequestParam(name="prefix", required=false) String prefix, @RequestParam(name="query", required=false) String query, @RequestParam(name="dsoType", required=false) String dsoType, @RequestParam(name="scope", required=false) String dsoScope, @RequestParam(name="configuration", required=false) String configuration, List<SearchFilter> searchFilters, Pageable page) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Facetting on facet " + facetName + " with scope: " + StringUtils.trimToEmpty((String)dsoScope) + ", dsoType: " + StringUtils.trimToEmpty((String)dsoType) + ", prefix: " + StringUtils.trimToEmpty((String)prefix) + ", query: " + StringUtils.trimToEmpty((String)query) + ", filters: " + Objects.toString(searchFilters) + ", page: " + Objects.toString(page));
        }
        FacetResultsRest facetResultsRest = this.discoveryRestRepository.getFacetObjects(facetName, prefix, query, dsoType, dsoScope, configuration, searchFilters, page);
        FacetResultsResource facetResultsResource = (FacetResultsResource)this.converter.toResource((RestModel)facetResultsRest);
        this.halLinkService.addLinks((HALResource)facetResultsResource, page);
        return facetResultsResource;
    }
}

