/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.services.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/authn/shibboleth"})
@RestController
public class ShibbolethRestController
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ShibbolethRestController.class);
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;

    public void afterPropertiesSet() {
        this.discoverableEndpointsService.register((Object)this, Arrays.asList(new Link("/api/authn", "shibboleth")));
    }

    @RequestMapping(method={RequestMethod.GET})
    public void shibboleth(HttpServletResponse response, @RequestParam(name="redirectUrl", required=false) String redirectUrl) throws IOException {
        if (redirectUrl == null) {
            redirectUrl = this.configurationService.getProperty("dspace.ui.url");
        }
        log.info("Redirecting to " + redirectUrl);
        response.sendRedirect(redirectUrl);
    }
}

