/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.authorization.AuthorizationRestUtil;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.AuthorizationRest;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="authz.authorization")
public class AuthorizationRestRepository
extends DSpaceRestRepository<AuthorizationRest, String> {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationRestRepository.class);
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private AuthorizationRestUtil authorizationRestUtil;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EPersonService epersonService;
    @Autowired
    protected ConverterService converter;

    @PreAuthorize(value="hasPermission(#id, 'authorization', 'READ')")
    public AuthorizationRest findOne(Context context, String id) {
        String featureName;
        AuthorizationRest authorizationRest = null;
        try {
            featureName = this.authorizationRestUtil.getFeatureName(id);
        }
        catch (IllegalArgumentException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
        try {
            EPerson user;
            BaseObjectRest object = null;
            try {
                object = this.authorizationRestUtil.getObject(context, id);
            }
            catch (IllegalArgumentException e) {
                log.warn("Object informations not found in the specified id " + id, (Throwable)e);
                return null;
            }
            AuthorizationFeature authorizationFeature = null;
            if (featureName != null) {
                authorizationFeature = this.authorizationFeatureService.find(featureName);
            }
            if (authorizationFeature == null) {
                return null;
            }
            try {
                user = this.authorizationRestUtil.getEperson(context, id);
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid eperson informations in the specified id " + id, (Throwable)e);
                return null;
            }
            EPerson currUser = context.getCurrentUser();
            if (currUser != user) {
                context.switchContextUser(user);
            }
            if (this.authorizationFeatureService.isAuthorized(context, authorizationFeature, object)) {
                Authorization authz = new Authorization();
                authz.setEperson(user);
                authz.setFeature(authorizationFeature);
                authz.setObject(object);
                authorizationRest = (AuthorizationRest)this.converter.toRest((Object)authz, this.utils.obtainProjection());
            }
            if (currUser != user) {
                context.restoreContextUser();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return authorizationRest;
    }

    @PreAuthorize(value="#epersonUuid==null || hasPermission(#epersonUuid, 'EPERSON', 'READ')")
    @SearchRestMethod(name="object")
    public Page<AuthorizationRest> findByObject(@Parameter(value="uri", required=true) String uri, @Parameter(value="eperson") UUID epersonUuid, Pageable pageable) throws AuthorizeException, SQLException {
        EPerson user;
        Context context = this.obtainContext();
        BaseObjectRest obj = this.utils.getBaseObjectRestFromUri(context, uri);
        if (obj == null) {
            return null;
        }
        EPerson currUser = context.getCurrentUser();
        if (ObjectUtils.notEqual((Object)currUser, (Object)(user = this.getUserFromRequestParameter(context, epersonUuid)))) {
            context.switchContextUser(user);
        }
        List features = this.authorizationFeatureService.findByResourceType(obj.getUniqueType());
        ArrayList<Authorization> authorizations = new ArrayList<Authorization>();
        for (AuthorizationFeature f : features) {
            if (!this.authorizationFeatureService.isAuthorized(context, f, obj)) continue;
            authorizations.add(new Authorization(user, f, obj));
        }
        if (currUser != user) {
            context.restoreContextUser();
        }
        return this.converter.toRestPage(authorizations, pageable, this.utils.obtainProjection());
    }

    @PreAuthorize(value="#epersonUuid==null || hasPermission(#epersonUuid, 'EPERSON', 'READ')")
    @SearchRestMethod(name="objectAndFeature")
    public AuthorizationRest findByObjectAndFeature(@Parameter(value="uri", required=true) String uri, @Parameter(value="eperson") UUID epersonUuid, @Parameter(value="feature", required=true) String featureName, Pageable pageable) throws AuthorizeException, SQLException {
        EPerson user;
        Context context = this.obtainContext();
        BaseObjectRest obj = this.utils.getBaseObjectRestFromUri(context, uri);
        if (obj == null) {
            return null;
        }
        EPerson currUser = context.getCurrentUser();
        if (currUser != (user = this.getUserFromRequestParameter(context, epersonUuid))) {
            context.switchContextUser(user);
        }
        AuthorizationFeature feature = this.authorizationFeatureService.find(featureName);
        AuthorizationRest authorizationRest = null;
        if (this.authorizationFeatureService.isAuthorized(context, feature, obj)) {
            Authorization authz = new Authorization();
            authz.setEperson(user);
            authz.setFeature(feature);
            authz.setObject(obj);
            authorizationRest = (AuthorizationRest)this.converter.toRest((Object)authz, this.utils.obtainProjection());
        }
        if (currUser != user) {
            context.restoreContextUser();
        }
        return authorizationRest;
    }

    private EPerson getUserFromRequestParameter(Context context, UUID epersonUuid) throws AuthorizeException, SQLException {
        EPerson currUser;
        EPerson user = currUser = context.getCurrentUser();
        if (epersonUuid != null) {
            if (currUser == null) {
                throw new AuthorizeException("attempt to anonymously access the authorization of the eperson " + epersonUuid);
            }
            if (!this.authorizeService.isAdmin(context) && !epersonUuid.equals(currUser.getID())) {
                throw new AuthorizeException("attempt to access the authorization of the eperson " + epersonUuid + " only system administrators can see the authorization of other users");
            }
            user = (EPerson)this.epersonService.find(context, epersonUuid);
        } else {
            user = null;
        }
        return user;
    }

    public Class<AuthorizationRest> getDomainClass() {
        return AuthorizationRest.class;
    }

    public Page<AuthorizationRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("authorization", "findAll");
    }
}

