/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.PaginationException;
import org.dspace.app.rest.exception.RepositoryNotFoundException;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.LinkRest;
import org.dspace.app.rest.model.LinksRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.EmbeddedPage;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.projection.CompositeProjection;
import org.dspace.app.rest.projection.EmbedRelsProjection;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.repository.ReloadableEntityObjectRepository;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.RequestService;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class);
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int EMBED_MAX_LEVELS = 10;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    RequestService requestService;
    @Autowired
    @Qualifier(value="defaultConversionService")
    ConversionService conversionService;
    @Autowired(required=true)
    private List<DSpaceObjectService<? extends DSpaceObject>> dSpaceObjectServices;
    @Autowired
    private BitstreamFormatService bitstreamFormatService;
    @Autowired
    private ConverterService converter;
    @Autowired
    private ConfigurationService configurationService;
    private Map<Method, Optional<LinkRest>> linkAnnotationForMethod = new HashMap();

    public <T> Page<T> getPage(List<T> fullContents, @Nullable Pageable optionalPageable) {
        Pageable pageable = this.getPageable(optionalPageable);
        int total = fullContents.size();
        List<T> pageContent = null;
        if (pageable.getOffset() > (long)total) {
            throw new PaginationException((long)total);
        }
        pageContent = pageable.getOffset() + (long)pageable.getPageSize() > (long)total ? fullContents.subList(Math.toIntExact(pageable.getOffset()), total) : fullContents.subList(Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getOffset()) + pageable.getPageSize());
        return new PageImpl(pageContent, pageable, (long)total);
    }

    public Pageable getPageable(@Nullable Pageable optionalPageable) {
        return optionalPageable != null ? optionalPageable : PageRequest.of((int)0, (int)20);
    }

    public Link linkToSingleResource(RestAddressableModel data, String rel) {
        return ((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo((Class)data.getController(), (Object[])new Object[]{data.getCategory(), data.getTypePlural()}).slash((Object)this.getIdentifierForLink(data))).withRel(rel);
    }

    public Link linkToSubResource(RestAddressableModel data, String rel) {
        return this.linkToSubResource(data, rel, rel);
    }

    public Link linkToSubResource(RestAddressableModel data, String rel, String path) {
        return ((WebMvcLinkBuilder)((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo((Class)data.getController(), (Object[])new Object[]{data.getCategory(), data.getTypePlural()}).slash((Object)this.getIdentifierForLink(data))).slash((Object)path)).withRel(rel);
    }

    private Serializable getIdentifierForLink(RestAddressableModel data) {
        Object identifier = data.toString();
        if (data instanceof BaseObjectRest) {
            identifier = ((BaseObjectRest)data).getId();
        }
        return identifier;
    }

    public DSpaceRestRepository getResourceRepository(String apiCategory, String modelPlural) {
        String model = Utils.makeSingular((String)modelPlural);
        return this.getResourceRepositoryByCategoryAndModel(apiCategory, model);
    }

    public DSpaceRestRepository getResourceRepositoryByCategoryAndModel(String apiCategory, String modelSingular) {
        try {
            return (DSpaceRestRepository)this.applicationContext.getBean(apiCategory + "." + modelSingular, DSpaceRestRepository.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new RepositoryNotFoundException(apiCategory, modelSingular);
        }
    }

    public String[] getRepositories() {
        return this.applicationContext.getBeanNamesForType(DSpaceRestRepository.class);
    }

    public static String makeSingular(String modelPlural) {
        if (modelPlural.equals("communities")) {
            return "community";
        }
        if (modelPlural.equals("authorities")) {
            return "authority";
        }
        if (modelPlural.equals("resourcepolicies")) {
            return "resourcepolicy";
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)modelPlural, (CharSequence)"processes")) {
            return "process";
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)modelPlural, (CharSequence)"versionhistories")) {
            return "versionhistory";
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)modelPlural, (CharSequence)"properties")) {
            return "property";
        }
        return modelPlural.replaceAll("s$", "");
    }

    public LinkRestRepository getLinkResourceRepository(String apiCategory, String modelPlural, String rel) {
        String model = Utils.makeSingular((String)modelPlural);
        try {
            return (LinkRestRepository)this.applicationContext.getBean(apiCategory + "." + model + "." + rel, LinkRestRepository.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new RepositoryNotFoundException(apiCategory, model);
        }
    }

    public LinkRest getClassLevelLinkRest(String rel, Class<? extends RestAddressableModel> restClass) {
        Optional<LinkRest> optionalLinkRest = this.getLinkRests(restClass).stream().filter(linkRest -> rel.equals(linkRest.name())).findFirst();
        return optionalLinkRest.isPresent() ? optionalLinkRest.get() : null;
    }

    public String getMetadataKey(String schema, String element, String qualifier) {
        return org.dspace.core.Utils.standardize((String)schema, (String)element, (String)qualifier, (String)".");
    }

    public static File getFile(MultipartFile multipartFile, String prefixTempName, String suffixTempName) throws IOException, FileNotFoundException {
        String tempDir = ConfigurationManager.getProperty((String)"upload.temp.dir") != null ? ConfigurationManager.getProperty((String)"upload.temp.dir") : System.getProperty("java.io.tmpdir");
        File uploadDir = new File(tempDir);
        if (!uploadDir.exists() && !uploadDir.mkdir()) {
            uploadDir = null;
        }
        File file = File.createTempFile(prefixTempName + "-" + suffixTempName, ".temp", uploadDir);
        BufferedInputStream io = new BufferedInputStream(multipartFile.getInputStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        org.dspace.core.Utils.bufferedCopy((InputStream)io, (OutputStream)out);
        return file;
    }

    public static String getFileName(MultipartFile multipartFile) throws IOException, FileNotFoundException {
        String originalFilename = multipartFile.getOriginalFilename();
        if (originalFilename != null) {
            String[] parts = originalFilename.split("[\\/]");
            return parts[parts.length - 1];
        }
        return multipartFile.getName();
    }

    public List<BitstreamFormat> constructBitstreamFormatList(HttpServletRequest request, Context context) {
        return this.getStringListFromRequest(request).stream().map(link -> {
            if (link.endsWith("/")) {
                link = link.substring(0, link.length() - 1);
            }
            return link.substring(link.lastIndexOf(47) + 1);
        }).map(id -> {
            try {
                return (BitstreamFormat)this.bitstreamFormatService.find(context, Integer.parseInt(id));
            }
            catch (NumberFormatException | SQLException e) {
                log.error((Object)("Could not find bitstream format for id: " + id), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<DSpaceObject> constructDSpaceObjectList(Context context, List<String> list) {
        LinkedList<DSpaceObject> dSpaceObjects = new LinkedList<DSpaceObject>();
        for (String string : list) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            String uuid = string.substring(string.lastIndexOf(47) + 1);
            try {
                for (DSpaceObjectService dSpaceObjectService : this.dSpaceObjectServices) {
                    DSpaceObject dSpaceObject = dSpaceObjectService.find(context, UUIDUtils.fromString((String)uuid));
                    if (dSpaceObject == null) continue;
                    dSpaceObjects.add(dSpaceObject);
                }
            }
            catch (SQLException e) {
                log.error((Object)("Could not find DSpaceObject for UUID: " + uuid), (Throwable)e);
            }
        }
        return dSpaceObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFromRequest(HttpServletRequest request) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        try (Scanner scanner = new Scanner((InputStream)request.getInputStream());){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!StringUtils.hasText((String)line)) continue;
                list.add(line);
            }
        }
        return list;
    }

    public List<String> getStringListFromRequest(HttpServletRequest request) {
        List list = null;
        try {
            list = this.readFromRequest(request);
        }
        catch (IOException e) {
            log.error((Object)"Something went wrong with reading in the inputstream from the request", (Throwable)e);
        }
        return list;
    }

    public <T extends HALResource> T toResource(RestModel restObject) {
        return (T)this.converter.toResource(restObject);
    }

    public String[] getSortedUnion(String[] ... arrays) {
        TreeSet<String> set = new TreeSet<String>();
        String[][] stringArray = arrays;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] array;
            for (String string : array = stringArray[i]) {
                set.add(string);
            }
        }
        return set.toArray(arrays[0]);
    }

    public Method requireMethod(Class clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        throw new IllegalArgumentException("No such method in " + clazz + ": " + name);
    }

    public Projection obtainProjection() {
        ServletRequest servletRequest = this.requestService.getCurrentRequest().getServletRequest();
        List projectionNames = this.getValues(servletRequest, "projection");
        HashSet embedRels = new HashSet(this.getValues(servletRequest, "embed"));
        ArrayList<Object> projections = new ArrayList<Object>();
        for (String projectionName : projectionNames) {
            projections.add(this.converter.getProjection(projectionName));
        }
        if (!embedRels.isEmpty()) {
            projections.add(new EmbedRelsProjection(embedRels));
        }
        if (projections.isEmpty()) {
            return Projection.DEFAULT;
        }
        if (projections.size() == 1) {
            return (Projection)projections.get(0);
        }
        return new CompositeProjection(projections);
    }

    private List<String> getValues(ServletRequest servletRequest, String parameterName) {
        String[] rawValues = servletRequest.getParameterValues(parameterName);
        ArrayList<String> values = new ArrayList<String>();
        if (rawValues != null) {
            for (String rawValue : rawValues) {
                for (String value : rawValue.split(",")) {
                    String trimmedValue = value.trim();
                    if (trimmedValue.length() <= 0 || values.contains(trimmedValue)) continue;
                    values.add(trimmedValue);
                }
            }
        }
        return values;
    }

    public void embedOrLinkClassLevelRels(HALResource<RestAddressableModel> halResource, Link ... oldLinks) {
        Projection projection = ((RestAddressableModel)halResource.getContent()).getProjection();
        this.getLinkRests(((RestAddressableModel)halResource.getContent()).getClass()).stream().forEach(linkRest -> {
            Link link = this.linkToSubResource((RestAddressableModel)halResource.getContent(), linkRest.name());
            if (projection.allowEmbedding(halResource, linkRest, oldLinks)) {
                this.embedRelFromRepository(halResource, linkRest.name(), link, linkRest, oldLinks);
                halResource.add(link);
            } else if (projection.allowLinking(halResource, linkRest)) {
                halResource.add(link);
            }
        });
    }

    private List<LinkRest> getLinkRests(Class<? extends RestAddressableModel> restClass) {
        ArrayList<LinkRest> list = new ArrayList<LinkRest>();
        LinksRest linksAnnotation = restClass.getDeclaredAnnotation(LinksRest.class);
        if (linksAnnotation != null) {
            list.addAll(Arrays.asList(linksAnnotation.links()));
        }
        return list;
    }

    void embedRelFromRepository(HALResource<? extends RestAddressableModel> resource, String rel, Link link, LinkRest linkRest) {
        this.embedRelFromRepository(resource, rel, link, linkRest, new Link[0]);
    }

    void embedRelFromRepository(HALResource<? extends RestAddressableModel> resource, String rel, Link link, LinkRest linkRest, Link ... oldLinks) {
        if (((RestAddressableModel)resource.getContent()).getEmbedLevel() == 10) {
            return;
        }
        Projection projection = ((RestAddressableModel)resource.getContent()).getProjection();
        LinkRestRepository linkRepository = this.getLinkResourceRepository(((RestAddressableModel)resource.getContent()).getCategory(), ((RestAddressableModel)resource.getContent()).getType(), rel);
        if (linkRepository.isEmbeddableRelation(resource.getContent(), rel)) {
            Method method = this.requireMethod(linkRepository.getClass(), linkRest.method());
            Object contentId = this.getContentIdForLinkMethod((RestAddressableModel)resource.getContent(), method);
            try {
                Object linkedObject = method.invoke((Object)linkRepository, null, contentId, null, projection);
                resource.embedResource(rel, this.wrapForEmbedding(resource, linkedObject, link, oldLinks));
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof AccessDeniedException) {
                    log.warn((Object)("Tried fetching resource: " + linkRest.name() + " for DSpaceObject with ID: " + contentId));
                }
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void embedMethodLevelRels(HALResource<? extends RestAddressableModel> resource) {
        if (((RestAddressableModel)resource.getContent()).getEmbedLevel() == 10) {
            return;
        }
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(((RestAddressableModel)resource.getContent()).getClass()).getPropertyDescriptors()) {
                Method readMethod = pd.getReadMethod();
                String propertyName = pd.getName();
                if (readMethod == null || "class".equals(propertyName)) continue;
                this.embedMethodLevelRel(resource, readMethod, propertyName);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public LinkRest findLinkAnnotation(Method readMethod) {
        Optional optional = (Optional)this.linkAnnotationForMethod.get(readMethod);
        if (optional == null) {
            LinkRest linkRest = (LinkRest)AnnotationUtils.findAnnotation((Method)readMethod, LinkRest.class);
            optional = linkRest != null ? Optional.of(linkRest) : Optional.empty();
            this.linkAnnotationForMethod.put(readMethod, optional);
        }
        return optional.isPresent() ? (LinkRest)optional.get() : null;
    }

    private void embedMethodLevelRel(HALResource<? extends RestAddressableModel> resource, Method readMethod, String propertyName) {
        String rel = propertyName;
        LinkRest linkRest = this.findLinkAnnotation(readMethod);
        try {
            if (linkRest != null) {
                if (!((RestAddressableModel)resource.getContent()).getProjection().allowEmbedding(resource, linkRest, new Link[0])) {
                    return;
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)linkRest.name())) {
                    rel = linkRest.name();
                }
                Link link = this.linkToSubResource((RestAddressableModel)resource.getContent(), rel);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)linkRest.method())) {
                    Object linkedObject = readMethod.invoke(resource.getContent(), new Object[0]);
                    resource.embedResource(rel, this.wrapForEmbedding(resource, linkedObject, link));
                } else {
                    this.embedRelFromRepository(resource, rel, link, linkRest);
                }
            } else if (RestAddressableModel.class.isAssignableFrom(readMethod.getReturnType())) {
                RestAddressableModel linkedObject = (RestAddressableModel)readMethod.invoke(resource.getContent(), new Object[0]);
                resource.embedResource(rel, linkedObject == null ? null : this.wrapForEmbedding(resource, (Object)linkedObject, this.linkToSubResource((RestAddressableModel)resource.getContent(), rel)));
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object wrapForEmbedding(HALResource<? extends RestAddressableModel> resource, Object linkedObject, Link link) {
        return this.wrapForEmbedding(resource, linkedObject, link, new Link[0]);
    }

    private Object wrapForEmbedding(HALResource<? extends RestAddressableModel> resource, Object linkedObject, Link link, Link ... oldLinks) {
        int childEmbedLevel = ((RestAddressableModel)resource.getContent()).getEmbedLevel() + 1;
        Link[] newList = Arrays.copyOf(oldLinks, oldLinks.length + 1);
        newList[oldLinks.length] = link;
        if (linkedObject instanceof RestAddressableModel) {
            RestAddressableModel restObject2 = (RestAddressableModel)linkedObject;
            restObject2.setEmbedLevel(childEmbedLevel);
            return this.converter.toResource((RestModel)restObject2, newList);
        }
        if (linkedObject instanceof Page) {
            Page page = (Page)linkedObject;
            return new EmbeddedPage(link.getHref(), page.map(restObject -> {
                restObject.setEmbedLevel(childEmbedLevel);
                return this.converter.toResource((RestModel)restObject, newList);
            }), null, link.getRel().value());
        }
        if (linkedObject instanceof List) {
            List list = (List)linkedObject;
            if (list.size() > 0) {
                PageImpl page = new PageImpl(list.subList(0, list.size() > 20 ? 20 : list.size()), (Pageable)PageRequest.of((int)0, (int)20), (long)list.size());
                return new EmbeddedPage(link.getHref(), page.map(restObject -> {
                    restObject.setEmbedLevel(childEmbedLevel);
                    return this.converter.toResource((RestModel)restObject, newList);
                }), list, link.getRel().value());
            }
            PageImpl page = new PageImpl(list);
            return new EmbeddedPage(link.getHref(), (Page)page, list, link.getRel().value());
        }
        return linkedObject;
    }

    private Object getContentIdForLinkMethod(RestAddressableModel restObject, Method linkMethod) {
        Serializable contentId = ((BaseObjectRest)restObject).getId();
        Class<?> requiredIdType = linkMethod.getParameterTypes()[1];
        if (!requiredIdType.isAssignableFrom(contentId.getClass())) {
            if (requiredIdType.equals(UUID.class)) {
                contentId = UUID.fromString(contentId.toString());
            } else if (requiredIdType.equals(Integer.class)) {
                contentId = Integer.valueOf(Integer.parseInt(contentId.toString()));
            } else if (requiredIdType.equals(Long.class)) {
                contentId = Long.valueOf(Long.parseLong(contentId.toString()));
            } else {
                throw new IllegalArgumentException("Cannot cast " + restObject.getClass() + " id type " + contentId.getClass() + " to id type required by " + linkMethod.getDeclaringClass() + "#" + linkMethod.getName() + ": " + requiredIdType);
            }
        }
        return contentId;
    }

    public Serializable castToPKClass(ReloadableEntityObjectRepository repository, String pkStr) {
        return (Serializable)this.conversionService.convert((Object)pkStr, repository.getPKClass());
    }

    public Object getDSpaceAPIObjectFromRest(Context context, BaseObjectRest restObj) throws IllegalArgumentException, SQLException {
        DSpaceRestRepository repository = this.getResourceRepositoryByCategoryAndModel(restObj.getCategory(), restObj.getType());
        Serializable pk = this.castToPKClass((ReloadableEntityObjectRepository)repository, restObj.getId().toString());
        return ((ReloadableEntityObjectRepository)repository).findDomainObjectByPk(context, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseObjectRest getBaseObjectRestFromUri(Context context, String uri) throws SQLException {
        Serializable pk;
        DSpaceRestRepository repository;
        String dspaceUrl = this.configurationService.getProperty("dspace.server.url");
        if (!org.apache.commons.lang3.StringUtils.startsWith((CharSequence)uri, (CharSequence)dspaceUrl)) {
            throw new IllegalArgumentException("the supplied uri is not valid: " + uri);
        }
        String[] uriParts = uri.substring(dspaceUrl.length() + (dspaceUrl.endsWith("/") ? 0 : 1) + "api/".length()).split("/", 3);
        if (uriParts.length != 3) {
            throw new IllegalArgumentException("the supplied uri is not valid: " + uri);
        }
        try {
            repository = this.getResourceRepository(uriParts[0], uriParts[1]);
            if (!(repository instanceof ReloadableEntityObjectRepository)) {
                throw new IllegalArgumentException("the supplied uri is not valid: " + uri);
            }
        }
        catch (RepositoryNotFoundException e) {
            throw new IllegalArgumentException("the supplied uri is not valid: " + uri, e);
        }
        try {
            pk = this.castToPKClass((ReloadableEntityObjectRepository)repository, uriParts[2]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the supplied uri is not valid: " + uri, e);
        }
        try {
            context.turnOffAuthorisationSystem();
            BaseObjectRest baseObjectRest = (BaseObjectRest)repository.findOne(context, pk);
            return baseObjectRest;
        }
        finally {
            context.restoreAuthSystemState();
        }
    }
}

