/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.rest.converter.DiscoverFacetValueConverter;
import org.dspace.app.rest.converter.SearchFilterToAppliedFilterConverter;
import org.dspace.app.rest.model.SearchFacetEntryRest;
import org.dspace.app.rest.model.SearchFacetValueRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.dspace.app.rest.parameter.SearchFilter;
import org.dspace.app.rest.projection.Projection;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class DiscoverFacetsConverter {
    private static final Logger log = Logger.getLogger(DiscoverFacetsConverter.class);
    private DiscoverFacetValueConverter facetValueConverter = new DiscoverFacetValueConverter();
    @Autowired
    private SearchService searchService;

    public SearchResultsRest convert(Context context, String query, List<String> dsoTypes, String configurationName, String dsoScope, List<SearchFilter> searchFilters, Pageable page, DiscoveryConfiguration configuration, DiscoverResult searchResult, Projection projection) {
        SearchResultsRest searchResultsRest = new SearchResultsRest();
        searchResultsRest.setProjection(projection);
        this.setRequestInformation(context, query, dsoTypes, configurationName, dsoScope, searchFilters, page, searchResultsRest);
        this.addFacetValues(context, searchResult, searchResultsRest, configuration, projection);
        return searchResultsRest;
    }

    public void addFacetValues(Context context, DiscoverResult searchResult, SearchResultsRest resultsRest, DiscoveryConfiguration configuration, Projection projection) {
        List facets = configuration.getSidebarFacets();
        for (DiscoverySearchFilterFacet field : CollectionUtils.emptyIfNull((Collection)facets)) {
            List facetValues = searchResult.getFacetResult(field);
            SearchFacetEntryRest facetEntry = new SearchFacetEntryRest(field.getIndexFieldName());
            facetEntry.setProjection(projection);
            int valueCount = 0;
            facetEntry.setHasMore(false);
            facetEntry.setFacetLimit(field.getFacetLimit());
            if (field.exposeMinAndMaxValue()) {
                this.handleExposeMinMaxValues(context, field, facetEntry);
            }
            facetEntry.setExposeMinMax(field.exposeMinAndMaxValue());
            facetEntry.setFacetType(field.getType());
            for (DiscoverResult.FacetResult value : CollectionUtils.emptyIfNull((Collection)facetValues)) {
                if (valueCount < field.getFacetLimit()) {
                    SearchFacetValueRest valueRest = this.facetValueConverter.convert(value, projection);
                    facetEntry.addValue(valueRest);
                } else {
                    facetEntry.setHasMore(true);
                }
                ++valueCount;
            }
            resultsRest.addFacetEntry(facetEntry);
        }
    }

    private void handleExposeMinMaxValues(Context context, DiscoverySearchFilterFacet field, SearchFacetEntryRest facetEntry) {
        try {
            String minValue = this.searchService.calculateExtremeValue(context, field.getIndexFieldName() + "_min", field.getIndexFieldName() + "_min_sort", DiscoverQuery.SORT_ORDER.asc);
            String maxValue = this.searchService.calculateExtremeValue(context, field.getIndexFieldName() + "_max", field.getIndexFieldName() + "_max_sort", DiscoverQuery.SORT_ORDER.desc);
            if (StringUtils.isNotBlank((CharSequence)minValue) && StringUtils.isNotBlank((CharSequence)maxValue)) {
                facetEntry.setMinValue(minValue);
                facetEntry.setMaxValue(maxValue);
            }
        }
        catch (SearchServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setRequestInformation(Context context, String query, List<String> dsoTypes, String configurationName, String scope, List<SearchFilter> searchFilters, Pageable page, SearchResultsRest resultsRest) {
        resultsRest.setQuery(query);
        resultsRest.setConfiguration(configurationName);
        resultsRest.setDsoTypes(dsoTypes);
        resultsRest.setSort(SearchResultsRest.Sorting.fromPage(page));
        resultsRest.setScope(scope);
        SearchFilterToAppliedFilterConverter searchFilterToAppliedFilterConverter = new SearchFilterToAppliedFilterConverter();
        for (SearchFilter searchFilter : CollectionUtils.emptyIfNull(searchFilters)) {
            resultsRest.addAppliedFilter(searchFilterToAppliedFilterConverter.convertSearchFilter(context, searchFilter));
        }
    }
}

